/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TimeValueWidget;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;

public class DateTimeValueWidget
extends HBox
implements HasViewState,
HasValue<LocalDateTime> {
    private final SimpleObjectProperty<LocalDateTime> value = new SimpleObjectProperty();
    private Label readonlyLabel;
    DateValueWidget dateField;
    private TimeValueWidget timeField;
    private final ViewState viewState = new ViewState();
    private String promptText;
    private DateTimeFormatter formatter;
    private Supplier<LocalTime> initialTimeSupplier = () -> LocalTime.MIN;
    private ActionData actionData;

    public DateTimeValueWidget(boolean ro) {
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.viewState.setReadonly(ro);
        this.promptText = this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
        this.getStyleClass().addAll((Object[])new String[]{"date-time-value-widget", "simple-widget"});
        this.value.addListener((source, oldValue, newValue) -> this.renderValue());
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> {
            this.promptText = ViewState.isImmutable(n.intValue()) ? "\u2014" : UiUtil.NULL_TEXT;
            this.updateState();
        });
    }

    public void requestFocus() {
        if (this.dateField != null) {
            this.dateField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    @Override
    public ObjectProperty<LocalDateTime> valueProperty() {
        return this.value;
    }

    public LocalDateTime getValue() {
        return (LocalDateTime)this.valueProperty().get();
    }

    public void setValue(LocalDateTime date) {
        this.valueProperty().set((Object)date);
    }

    public void setInitialTimeSupplier(Supplier<LocalTime> val) {
        this.initialTimeSupplier = Objects.requireNonNull(val);
    }

    public void setActionHandler(IconShape iconShape, String tooltip, Consumer<Region> handler) {
        this.actionData = handler == null ? null : new ActionData(Objects.requireNonNull(iconShape), tooltip, handler);
        this.updateState();
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.dateField = null;
            this.timeField = null;
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.dateField == null) {
                this.dateField = new DateValueWidget(false);
                HBox.setHgrow((Node)this.dateField, (Priority)Priority.ALWAYS);
                this.timeField = new TimeValueWidget(false);
                ChangeListener listener = (s, o, n) -> {
                    LocalDate date = (LocalDate)this.dateField.valueProperty().get();
                    if (date == null) {
                        this.value.set(null);
                        return;
                    }
                    LocalTime time = (LocalTime)this.timeField.valueProperty().get();
                    if (time == null) {
                        time = this.initialTimeSupplier.get();
                    }
                    this.value.set((Object)LocalDateTime.of(date, time));
                };
                this.dateField.valueProperty().addListener(listener);
                this.timeField.valueProperty().addListener(listener);
            }
            if (this.actionData != null) {
                Button button = new Button();
                button.setOnAction(evt -> this.actionData.handler.accept((Region)button));
                button.setGraphic((Node)new IconNode(this.actionData.shape, (Styleable)button, StandardIconIntentions.CONTROLS_QTY, (Styleable)button));
                if (!TextUtil.isBlank((String)this.actionData.tooltip)) {
                    UiUtil.setTooltip((Node)button, this.actionData.tooltip);
                }
                button.getStyleClass().add((Object)"xtrip-button");
                this.getChildren().setAll((Object[])new Node[]{this.dateField, this.timeField, button});
            } else {
                this.getChildren().setAll((Object[])new Node[]{this.dateField, this.timeField});
            }
        }
        this.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"readonly"), this.viewState.isImmutable());
        this.renderValue();
    }

    private DateTimeFormatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = DateTimeFormatter.ofPattern(LocaleManager.get().getCurrentLocaleData().getDateTimeFormatPattern());
        }
        return this.formatter;
    }

    private void renderValue() {
        LocalDateTime val = (LocalDateTime)this.value.get();
        if (this.readonlyLabel != null) {
            if (val == null) {
                this.readonlyLabel.setText(this.promptText);
            } else {
                this.readonlyLabel.setText(this.getFormatter().format(val));
            }
            return;
        }
        if (val == null) {
            this.dateField.valueProperty().set(null);
            this.timeField.valueProperty().set(null);
        } else {
            this.dateField.valueProperty().set((Object)val.toLocalDate());
            this.timeField.valueProperty().set((Object)val.toLocalTime());
        }
    }

    public boolean hasSameValue(LocalDateTime val) {
        LocalDateTime current = (LocalDateTime)this.value.get();
        if (current == null && val == null) {
            return true;
        }
        if (current == null || val == null) {
            return false;
        }
        return this.getFormatter().format(current).equalsIgnoreCase(this.getFormatter().format(val));
    }

    private static class ActionData {
        final IconShape shape;
        final String tooltip;
        final Consumer<Region> handler;

        ActionData(IconShape is, String tt, Consumer<Region> h) {
            this.shape = is;
            this.tooltip = tt;
            this.handler = h;
        }
    }
}

