/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.widgets.BaseNumberWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DoubleValueWidget;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class FloatValueWidget
extends BaseNumberWidget<Float> {
    public FloatValueWidget(boolean readonly) {
        super(readonly);
    }

    @Override
    protected StringConverter<Float> createConverter() {
        return new StringConverter<Float>(){
            private final DecimalFormat nf;
            {
                LocaleManager lm = LocaleManager.get();
                this.nf = lm.getLocaleData(lm.getCurrentLocale()).getNumberFormat();
            }

            public String toString(Float object) {
                return object == null ? "" : this.nf.format(object.floatValue());
            }

            public Float fromString(String string) {
                if (string == null) {
                    return null;
                }
                String str = string.trim();
                if (str.isEmpty()) {
                    return null;
                }
                Number obj = DoubleValueWidget.parseAsNumber(this.nf, str);
                if (obj instanceof Float) {
                    return (Float)obj;
                }
                return Float.valueOf(obj.floatValue());
            }
        };
    }
}

