/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public class RendererWidget
extends StackPane
implements HasViewState {
    private NodeRenderer renderer;
    private Object holdValue = null;
    private final ViewState viewState = new ViewState();

    public RendererWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"renderer-widget", "simple-widget"});
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void setRenderer(NodeRenderer value) {
        if (value == null) {
            this.getChildren().clear();
            this.renderer = null;
            return;
        }
        if (this.renderer != value) {
            this.renderer = value;
            Node node = this.renderer.createNode(this.viewState.isImmutable());
            this.renderer.setReadonly(this.viewState.isImmutable(), node);
            this.getChildren().setAll((Object[])new Node[]{node});
            this.renderer.setValue(node, this.holdValue);
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    private void updateState() {
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        if (this.renderer != null && !this.getChildren().isEmpty()) {
            this.renderer.setReadonly(this.viewState.isImmutable(), this.getValueNode());
        }
    }

    public Object getValue() {
        if (this.renderer != null && !this.getChildren().isEmpty()) {
            return this.renderer.getValue(this.getValueNode());
        }
        return this.holdValue;
    }

    public void setValue(Object value) {
        Node node;
        this.holdValue = value;
        if (this.renderer == null) {
            return;
        }
        if (this.getChildren().isEmpty()) {
            node = this.renderer.createNode(this.viewState.isImmutable());
            this.renderer.setReadonly(this.viewState.isImmutable(), node);
            this.getChildren().setAll((Object[])new Node[]{node});
        } else {
            node = this.getValueNode();
        }
        this.renderer.setValue(node, value);
    }

    public Node getValueNode() {
        return this.getChildren().isEmpty() ? null : (Node)this.getChildren().get(0);
    }
}

