/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.Buttons;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextArea;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextField;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.TextUtil;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class TextAreaWidget
extends StackPane
implements HasViewState,
HasValue<String> {
    private final SimpleObjectProperty<String> value = new SimpleObjectProperty();
    private final CustomTextArea textArea = new CustomTextArea();
    private final ViewState viewState = new ViewState();
    private String promptText = this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
    private boolean notExpandable;

    public TextAreaWidget(boolean ro) {
        this.getStyleClass().addAll((Object[])new String[]{"text-area-widget", "simple-widget"});
        this.textArea.setPromptText(this.promptText);
        this.hoverProperty().addListener((s, o, n) -> this.updateState());
        this.textArea.textProperty().addListener((obj, o, n) -> this.updateState());
        this.textArea.editableProperty().addListener((obj, o, n) -> this.updateState());
        Bindings.bindBidirectional(this.value, (Property)this.textArea.textProperty());
        this.getChildren().add((Object)this.textArea);
        this.viewState.stateProperty().addListener((s, o, n) -> {
            boolean immutable = ViewState.isImmutable(n.intValue());
            this.promptText = immutable ? "\u2014" : UiUtil.NULL_TEXT;
            this.textArea.setEditable(!immutable);
            this.updateState();
        });
        this.viewState.setReadonly(ro);
    }

    public void requestFocus() {
        if (this.textArea != null) {
            this.textArea.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setPrefRowCount(int val) {
        this.textArea.setPrefRowCount(val);
    }

    public void setPromptText(String val) {
        this.textArea.setPromptText(val);
    }

    public void setWrapText(boolean val) {
        this.textArea.setWrapText(val);
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setMonospace(boolean val) {
        this.textArea.setMonospace(val);
    }

    public void setNotExpandable(boolean val) {
        this.notExpandable = val;
    }

    public String getValue() {
        return (String)this.value.get();
    }

    public void setValue(String val) {
        this.value.set((Object)val);
    }

    @Override
    public ObjectProperty<String> valueProperty() {
        return this.value;
    }

    public boolean hasSameText(String text) {
        return CustomTextField.sameNormalizedText(this.getValue(), text);
    }

    private void updateState() {
        this.textArea.setPromptText(this.promptText);
        boolean empty = TextUtil.isBlank((String)this.textArea.getText());
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, empty);
        if (this.isHover() && !empty && !this.notExpandable) {
            if (this.getChildren().size() == 1) {
                HBox box = new HBox();
                box.getStyleClass().add((Object)"floating-buttons");
                box.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                StackPane.setAlignment((Node)box, (Pos)Pos.TOP_RIGHT);
                if (!this.viewState.isImmutable()) {
                    box.getChildren().add((Object)Buttons.clearButton(() -> {
                        this.textArea.clear();
                        this.textArea.requestFocus();
                    }));
                }
                box.getChildren().add((Object)Buttons.expandButton(() -> {
                    CustomTextArea ta = new CustomTextArea();
                    ta.setMonospace(this.textArea.isMonospace());
                    ta.setEditable(!this.viewState.isImmutable());
                    ta.setText(this.getValue());
                    Dialog dialog = new Dialog();
                    dialog.setTitle(Messages.General_Text).setBody((Node)ta).setExpandToParent(true);
                    if (ta.isEditable()) {
                        dialog.addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Apply, () -> this.setValue(ta.getText()));
                    } else {
                        dialog.addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Close);
                    }
                    dialog.show((Node)this);
                }));
                this.getChildren().add((Object)box);
            }
            return;
        }
        if (this.getChildren().size() > 1) {
            this.getChildren().setAll((Object[])new Node[]{this.textArea});
        }
    }
}

