/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.PopupWindow;

public class TextFieldWidget
extends StackPane
implements HasViewState,
HasValue<String> {
    private final SimpleObjectProperty<String> value = new SimpleObjectProperty();
    private final ReadOnlyBooleanWrapper controlFocused = new ReadOnlyBooleanWrapper();
    private Label readonlyLabel;
    private ClearableTextField textField;
    private String promptText;
    private final ViewState viewState = new ViewState();
    private char[] specialChars;
    private PopupControl specialCharsPopup;
    private ActionData actionData;
    private TextFormatter<?> formatter;

    public TextFieldWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.promptText = ro ? "\u2014" : UiUtil.NULL_TEXT;
        this.getStyleClass().addAll((Object[])new String[]{"text-field-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.value.addListener(evt -> this.renderValue());
        this.viewState.stateProperty().addListener((s, o, n) -> {
            this.promptText = ViewState.isImmutable(n.intValue()) ? "\u2014" : UiUtil.NULL_TEXT;
            this.updateState();
        });
        this.controlFocused.addListener((s, o, n) -> this.handleSpecialCharsPane((boolean)n));
        this.updateState();
    }

    public void requestFocus() {
        if (this.textField != null) {
            this.textField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public ReadOnlyBooleanProperty controlFocusedProperty() {
        return this.controlFocused.getReadOnlyProperty();
    }

    public void setActionHandler(IconShape iconShape, String tooltip, Consumer<Region> handler) {
        this.actionData = handler == null ? null : new ActionData(Objects.requireNonNull(iconShape), tooltip, handler);
        this.updateState();
    }

    public void setItemsSupplier(Supplier<List<String>> val) {
        if (val == null) {
            this.setActionHandler(null, null, null);
        } else {
            this.setActionHandler(StandardIconShapes.COMBOBOX_DOWN_ARROW, Messages.General_Choose_value_from_list, node -> UiUtil.showListPopup((List)val.get(), item -> item, item -> this.setValue((String)item), node));
        }
    }

    @Override
    public ObjectProperty<String> valueProperty() {
        return this.value;
    }

    public void setSpecialChars(char[] val) {
        this.specialChars = val;
    }

    public void setTextFormatter(TextFormatter<?> val) {
        this.formatter = val;
        if (this.textField != null) {
            this.textField.setTextFormatter(this.formatter);
        }
    }

    public String getValue() {
        return (String)this.value.get();
    }

    public void setValue(String val) {
        this.value.set((Object)val);
    }

    public void setPromptText(String val) {
        this.promptText = val;
        if (this.textField != null) {
            this.textField.setPromptText(this.promptText);
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public boolean hasSameText(String text) {
        return CustomTextField.sameNormalizedText((String)this.value.get(), text);
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            if (this.textField != null) {
                this.textField.setTextFormatter(null);
            }
            this.textField = null;
            this.controlFocused.unbind();
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.textField == null) {
                this.textField = new ClearableTextField(){

                    public void clear() {
                        this.setText(null);
                    }
                };
                this.textField.setPromptText(this.promptText);
                this.textField.textProperty().addListener((s, o, n) -> this.value.set(n));
                this.textField.setTextFormatter(this.formatter);
                this.controlFocused.bind((ObservableValue)this.textField.focusedProperty());
            }
            if (this.actionData != null) {
                HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
                Button button = new Button();
                button.setOnAction(evt -> this.actionData.handler.accept((Region)button));
                button.setGraphic((Node)new IconNode(this.actionData.shape, (Styleable)button, StandardIconIntentions.CONTROLS_QTY, (Styleable)button));
                if (!TextUtil.isBlank((String)this.actionData.tooltip)) {
                    UiUtil.setTooltip((Node)button, this.actionData.tooltip);
                }
                button.getStyleClass().add((Object)"xtrip-button");
                this.getChildren().setAll((Object[])new Node[]{new HBox(new Node[]{this.textField, button})});
            } else {
                this.getChildren().setAll((Object[])new Node[]{this.textField});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void handleSpecialCharsPane(boolean focused) {
        if (!focused) {
            if (this.specialCharsPopup != null) {
                this.specialCharsPopup.hide();
                this.specialCharsPopup = null;
            }
            return;
        }
        if (this.specialChars == null) {
            return;
        }
        if (this.specialCharsPopup == null) {
            FlowPane pane = new FlowPane();
            for (char ch : this.specialChars) {
                Button button = new Button(String.valueOf(ch));
                button.setOnAction(evt -> this.textField.insertText(this.textField.getCaretPosition(), String.valueOf(ch)));
                pane.getChildren().add((Object)button);
            }
            pane.getStyleClass().add((Object)"text-field-special-chars-pane");
            pane.maxWidthProperty().bind((ObservableValue)this.textField.widthProperty());
            this.specialCharsPopup = UiUtil.createPopup((Parent)pane);
            this.specialCharsPopup.setAutoHide(false);
            this.specialCharsPopup.setHideOnEscape(false);
        }
        UiUtil.showPopup((PopupWindow)this.specialCharsPopup, (Region)this.textField);
    }

    private void renderValue() {
        String val = (String)this.value.get();
        if (this.readonlyLabel != null) {
            this.readonlyLabel.setText(val == null ? (this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT) : val);
        } else {
            this.textField.setText(val);
        }
    }

    private static class ActionData {
        final IconShape shape;
        final String tooltip;
        final Consumer<Region> handler;

        ActionData(IconShape is, String tt, Consumer<Region> h) {
            this.shape = is;
            this.tooltip = tt;
            this.handler = h;
        }
    }
}

