/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class BooleanColumn<T>
extends BigTableWidgetColumn<T, Boolean> {
    private final Function<T, Boolean> getter;
    private final BiConsumer<T, Boolean> setter;
    private final Callback<TableColumn<T, Boolean>, TableCell<T, Boolean>> cellFactory = column -> new BooleanCell();
    StringConverter<Boolean> converter;

    public BooleanColumn(Function<T, Boolean> aGetter, BiConsumer<T, Boolean> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    protected Boolean getCellValue(T row) {
        return this.getter.apply(row);
    }

    @Override
    protected void setCellValue(T row, Boolean value) {
        this.setter.accept(row, value);
    }

    @Override
    protected boolean isCellValueChanged(T row, Boolean value) {
        return !Objects.equals(value, this.getter.apply(row));
    }

    @Override
    protected Callback<TableColumn<T, Boolean>, TableCell<T, Boolean>> getCellFactory() {
        return this.cellFactory;
    }

    public void setConverter(StringConverter<Boolean> value) {
        this.converter = value;
        this.refresh();
    }

    private class BooleanCell
    extends TableCell<T, Boolean> {
        private BooleanValueWidget widget;
        private boolean internalChange;

        BooleanCell() {
        }

        protected void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.widget == null) {
                this.widget = new BooleanValueWidget(true, !this.getTableView().isEditable() || BooleanColumn.this.isNotEditable());
                if (BooleanColumn.this.converter != null) {
                    this.widget.setConverter(BooleanColumn.this.converter);
                }
                this.widget.valueProperty().addListener((s, o, n) -> {
                    if (this.internalChange) {
                        return;
                    }
                    TableView tableView = this.getTableView();
                    if (tableView != null) {
                        TableColumn tableColumn = this.getTableColumn();
                        TableColumn.CellEditEvent editEvent = new TableColumn.CellEditEvent(tableView, new TablePosition(tableView, this.getIndex(), tableColumn), TableColumn.editCommitEvent(), n);
                        Event.fireEvent((EventTarget)tableColumn, (Event)editEvent);
                    }
                });
            } else {
                this.widget.getViewState().setReadonly(!this.getTableView().isEditable() || BooleanColumn.this.isNotEditable());
            }
            this.internalChange = true;
            this.widget.setValue(item == null ? false : item);
            this.internalChange = false;
            this.setGraphic((Node)this.widget);
        }
    }
}

