/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.DateWidgetCell;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class DateColumn<T>
extends BigTableWidgetColumn<T, LocalDate> {
    private final Function<T, LocalDate> getter;
    private final BiConsumer<T, LocalDate> setter;
    private final Callback<TableColumn<T, LocalDate>, TableCell<T, LocalDate>> cellFactory = column -> new DateWidgetCell();

    public DateColumn(Function<T, LocalDate> aGetter, BiConsumer<T, LocalDate> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    protected LocalDate getCellValue(T row) {
        return this.getter.apply(row);
    }

    @Override
    protected void setCellValue(T row, LocalDate value) {
        this.setter.accept(row, value);
    }

    @Override
    protected boolean isCellValueChanged(T row, LocalDate value) {
        return !MiscUtil.equals((Object)value, (Object)this.getter.apply(row));
    }

    @Override
    protected Callback<TableColumn<T, LocalDate>, TableCell<T, LocalDate>> getCellFactory() {
        return this.cellFactory;
    }
}

