/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.DateTimeWidgetCell;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDateTime;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class DateTimeColumn<T>
extends BigTableWidgetColumn<T, LocalDateTime> {
    private final Function<T, LocalDateTime> getter;
    private final BiConsumer<T, LocalDateTime> setter;
    private final Callback<TableColumn<T, LocalDateTime>, TableCell<T, LocalDateTime>> cellFactory = column -> new DateTimeWidgetCell();

    public DateTimeColumn(Function<T, LocalDateTime> aGetter, BiConsumer<T, LocalDateTime> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    protected LocalDateTime getCellValue(T row) {
        return this.getter.apply(row);
    }

    @Override
    protected void setCellValue(T row, LocalDateTime value) {
        this.setter.accept(row, value);
    }

    @Override
    protected boolean isCellValueChanged(T row, LocalDateTime value) {
        return !MiscUtil.equals((Object)value, (Object)this.getter.apply(row));
    }

    @Override
    protected Callback<TableColumn<T, LocalDateTime>, TableCell<T, LocalDateTime>> getCellFactory() {
        return this.cellFactory;
    }
}

