/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import java.time.LocalDateTime;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;

class DateTimeWidgetCell<T>
extends TableCell<T, LocalDateTime> {
    private static final PseudoClass EDITING_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"editing");
    private CustomLabel viewWidget;
    private DateTimeValueWidget editWidget;

    DateTimeWidgetCell() {
        this.setOnKeyPressed(ev -> ev.consume());
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            if (this.editWidget == null) {
                this.editWidget = new DateTimeValueWidget(false);
                this.editWidget.valueProperty().addListener((s, o, n) -> {
                    this.setItem(n);
                    this.fireEvent();
                });
                this.editWidget.setOnKeyReleased(evt -> {
                    if (evt.getCode() == KeyCode.ESCAPE) {
                        this.editWidget.setValue((LocalDateTime)this.getItem());
                        this.cancelEdit();
                        evt.consume();
                    }
                });
                this.editWidget.focusedProperty().addListener((src, o, n) -> {
                    if (!n.booleanValue() && this.isEditing()) {
                        this.commitEdit(this.editWidget.getValue());
                    } else if (!n.booleanValue() && o.booleanValue()) {
                        this.fireEvent();
                    }
                    this.pseudoClassStateChanged(EDITING_PSEUDOCLASS, this.isEditing());
                });
            }
            this.editWidget.setValue((LocalDateTime)this.getItem());
            this.setGraphic((Node)this.editWidget);
            this.editWidget.requestFocus();
        }
        this.getStyleClass().remove((Object)"edited");
    }

    public void cancelEdit() {
        super.cancelEdit();
        if (this.viewWidget == null) {
            this.viewWidget = new CustomLabel();
        }
        this.viewWidget.setText((String)StandardRenderers.DATE_TIME.apply(this.getItem()));
        this.setGraphic((Node)this.viewWidget);
    }

    protected void updateItem(LocalDateTime item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setGraphic(null);
            return;
        }
        if (this.isEditing()) {
            if (this.editWidget != null) {
                this.editWidget.setValue(item);
            }
            this.setGraphic((Node)this.editWidget);
        } else {
            if (this.viewWidget == null) {
                this.viewWidget = new CustomLabel();
            }
            this.viewWidget.setText((String)StandardRenderers.DATE_TIME.apply(item));
            this.setGraphic((Node)this.viewWidget);
        }
    }

    private void fireEvent() {
        TableView tableView = this.getTableView();
        if (tableView != null) {
            TableColumn tableColumn = this.getTableColumn();
            TableColumn.CellEditEvent editEvent = new TableColumn.CellEditEvent(tableView, new TablePosition(tableView, this.getIndex(), tableColumn), TableColumn.editCommitEvent(), (Object)this.editWidget.getValue());
            Event.fireEvent((EventTarget)tableColumn, (Event)editEvent);
        }
    }
}

