/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.KeyValueWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import javafx.util.Pair;
import javafx.util.StringConverter;

public class KeyValueColumn<T, K>
extends BigTableWidgetColumn<T, Pair<K, Object>> {
    private final Function<T, Pair<K, Object>> getter;
    private final BiConsumer<T, Pair<K, Object>> setter;
    private Function<K, NodeRenderer> rendererSupplier = key -> null;
    private StringConverter<K> keysConverter = StandardRenderers.GENERIC.createConverter();
    private Supplier<List<K>> keysSupplier;
    private final Callback<TableColumn<T, Pair<K, Object>>, TableCell<T, Pair<K, Object>>> cellFactory = column -> new KeyValueWidgetCell();

    public KeyValueColumn(Function<T, Pair<K, Object>> aGetter, BiConsumer<T, Pair<K, Object>> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    protected Pair<K, Object> getCellValue(T row) {
        return this.getter.apply(row);
    }

    @Override
    protected void setCellValue(T row, Pair<K, Object> value) {
        this.setter.accept(row, value);
    }

    @Override
    protected boolean isCellValueChanged(T row, Pair<K, Object> value) {
        return !MiscUtil.equals(value, this.getter.apply(row));
    }

    @Override
    protected Callback<TableColumn<T, Pair<K, Object>>, TableCell<T, Pair<K, Object>>> getCellFactory() {
        return this.cellFactory;
    }

    public void setKeysSupplier(Supplier<List<K>> keysSupplier) {
        this.keysSupplier = keysSupplier;
    }

    public void setKeyConverter(StringConverter<K> converter) {
        this.keysConverter = converter;
    }

    public void setRendererSupplier(Function<K, NodeRenderer> rendererSupplier) {
        this.rendererSupplier = Objects.requireNonNull(rendererSupplier);
    }

    class KeyValueWidgetCell
    extends TableCell<T, Pair<K, Object>> {
        private KeyValueWidget<K> widget;
        private boolean internalChange;

        KeyValueWidgetCell() {
            this.setOnKeyPressed(Event::consume);
        }

        protected void updateItem(Pair<K, Object> item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.widget == null) {
                this.widget = new KeyValueWidget(!this.getTableView().isEditable() || KeyValueColumn.this.isNotEditable());
                this.widget.setKeysSupplier(KeyValueColumn.this.keysSupplier);
                this.widget.setKeyConverter(KeyValueColumn.this.keysConverter);
                this.widget.setRendererSupplier(KeyValueColumn.this.rendererSupplier);
                this.widget.valueProperty().addListener((s, o, n) -> {
                    if (this.internalChange) {
                        return;
                    }
                    this.setItem(n);
                    TableView tableView = this.getTableView();
                    if (tableView != null) {
                        TableColumn tableColumn = this.getTableColumn();
                        TableColumn.CellEditEvent editEvent = new TableColumn.CellEditEvent(tableView, new TablePosition(tableView, this.getIndex(), tableColumn), TableColumn.editCommitEvent(), n);
                        Event.fireEvent((EventTarget)tableColumn, (Event)editEvent);
                    }
                });
            } else {
                this.widget.getViewState().setReadonly(!this.getTableView().isEditable() || KeyValueColumn.this.isNotEditable());
            }
            if (item != null) {
                this.internalChange = true;
                this.widget.setValue(item);
                this.internalChange = false;
            }
            this.setGraphic((Node)this.widget);
        }
    }
}

