/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dataview;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.CustomProgressIndicator;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.ArrayList;
import java.util.Collections;
import javafx.collections.ListChangeListener;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Pair;

public class DataViewWidget<I>
extends BorderPane {
    private final CustomTableView<I> tableView;
    private final ObservableMutex mutex;
    private final Button reloadButton;
    private final Button beginButton;
    private final Button prevButton;
    private final Button nextButton;
    private final Label pageLabel;
    private final StackPane indicatorPane;
    private DataViewHandler<I> handler;
    private String fieldName;
    private boolean dataLoaded;
    private Runnable defaultActionHandler;

    public DataViewWidget(boolean noControls) {
        this(noControls, new ObservableMutex());
    }

    public DataViewWidget(boolean noControls, ObservableMutex mtx) {
        this.getStyleClass().add((Object)"data-view-widget");
        this.mutex = mtx;
        this.mutex.acquiredProperty().addListener((s, o, n) -> this.updateState());
        ArrayList<Object> nodes = new ArrayList<Object>(8);
        this.pageLabel = new Label();
        this.pageLabel.getStyleClass().add((Object)"page-label");
        GridPane.setHgrow((Node)this.pageLabel, (Priority)Priority.ALWAYS);
        nodes.add(this.pageLabel);
        this.indicatorPane = new StackPane();
        GridPane.setHgrow((Node)this.indicatorPane, (Priority)Priority.NEVER);
        nodes.add(this.indicatorPane);
        if (!noControls) {
            this.reloadButton = new Button();
            this.reloadButton.getStyleClass().addAll((Object[])new String[]{"xtrip-button", "reload-button"});
            this.reloadButton.setGraphic((Node)new IconNode(StandardIconShapes.RELOAD_12x12, (Styleable)this.reloadButton, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)this.reloadButton));
            GridPane.setHgrow((Node)this.reloadButton, (Priority)Priority.NEVER);
            this.reloadButton.setOnAction(evt -> this.reloadData(null));
            UiUtil.setTooltip((Node)this.reloadButton, Messages.General_Refresh_data);
            nodes.add(this.reloadButton);
            this.beginButton = new Button();
            this.beginButton.setGraphic((Node)new IconNode(StandardIconShapes.LIST_BEGIN_12x12, (Styleable)this.beginButton, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)this.beginButton));
            this.beginButton.getStyleClass().addAll((Object[])new String[]{"xtrip-button", "begin-button"});
            GridPane.setHgrow((Node)this.beginButton, (Priority)Priority.NEVER);
            this.beginButton.setOnAction(evt -> this.reloadData(0));
            UiUtil.setTooltip((Node)this.beginButton, Messages.General_Go_to_first_page);
            this.prevButton = new Button();
            this.prevButton.setGraphic((Node)new IconNode(StandardIconShapes.LIST_PREV_14x14, (Styleable)this.prevButton, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)this.prevButton));
            this.prevButton.getStyleClass().addAll((Object[])new String[]{"xtrip-button", "prev-button"});
            GridPane.setHgrow((Node)this.prevButton, (Priority)Priority.NEVER);
            this.prevButton.setOnAction(evt -> {
                int offset = this.handler.getOffset() - this.handler.getLimit();
                if (offset < 0) {
                    offset = 0;
                }
                this.reloadData(offset);
            });
            UiUtil.setTooltip((Node)this.prevButton, Messages.General_Go_to_previous_page);
            this.nextButton = new Button();
            this.nextButton.setGraphic((Node)new IconNode(StandardIconShapes.LIST_NEXT_14x14, (Styleable)this.nextButton, StandardIconIntentions.BASIC_BUTTON_ACTION, (Styleable)this.nextButton));
            this.nextButton.getStyleClass().addAll((Object[])new String[]{"xtrip-button", "next-button"});
            GridPane.setHgrow((Node)this.nextButton, (Priority)Priority.NEVER);
            this.nextButton.setOnAction(evt -> this.reloadData(this.handler.getOffset() + this.handler.getLimit()));
            UiUtil.setTooltip((Node)this.nextButton, Messages.General_Go_to_next_page);
            GridPane buttonsPane = new GridPane();
            buttonsPane.getStyleClass().add((Object)"buttons-pane");
            buttonsPane.addRow(0, new Node[]{this.beginButton, this.prevButton, this.nextButton});
            nodes.add(buttonsPane);
        } else {
            this.reloadButton = null;
            this.beginButton = null;
            this.prevButton = null;
            this.nextButton = null;
        }
        GridPane pane = new GridPane();
        pane.getStyleClass().add((Object)"tool-pane");
        pane.addRow(0, nodes.toArray(new Node[nodes.size()]));
        this.setBottom((Node)pane);
        this.tableView = new CustomTableView();
        this.tableView.setMaxHeight(Double.MAX_VALUE);
        this.tableView.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
            if (this.defaultActionHandler == null) {
                return;
            }
            boolean isTargetRectangle = evt.getTarget().getClass().isAssignableFrom(Rectangle.class);
            if (evt.getClickCount() > 1 && !isTargetRectangle) {
                this.defaultActionHandler.run();
            }
        });
        this.tableView.addEventHandler(KeyEvent.KEY_RELEASED, evt -> {
            if (this.defaultActionHandler == null) {
                return;
            }
            if (!this.tableView.getSelectionModel().getSelectedCells().isEmpty() && evt.getCode() == KeyCode.ENTER) {
                this.defaultActionHandler.run();
            }
        });
        this.tableView.setOnSort(evt -> {
            evt.consume();
            this.reloadData(null);
        });
        this.setCenter((Node)this.tableView);
        this.updateState();
    }

    public Pane getAdditionalPanesContainer() {
        Pane result = (Pane)this.getTop();
        if (result == null) {
            result = new VBox();
            result.setMaxWidth(Double.MAX_VALUE);
            this.setTop((Node)result);
        }
        return result;
    }

    public void setHandler(DataViewHandler<I> value) {
        if (this.handler != null) {
            this.handler.getData().removeListener(this::dataChanged);
            this.handler.setWidget(null);
        }
        if (value != null) {
            value.getData().addListener(this::dataChanged);
            value.setWidget(this);
        } else {
            this.tableView.getItems().setAll(Collections.emptyList());
        }
        this.handler = value;
        this.updateState();
    }

    public DataViewHandler<I> getHandler() {
        return this.handler;
    }

    public void setPlaceholder(String value) {
        this.tableView.setPlaceholder((Node)new Label(value.length() > 0 ? Character.toUpperCase(value.charAt(0)) + value.substring(1) : value));
    }

    public void setDefaultActionHandler(Runnable value) {
        this.defaultActionHandler = value;
    }

    public CustomTableView<I> getTableView() {
        return this.tableView;
    }

    public void reloadData() {
        this.reloadData(null);
    }

    public boolean isDataLoaded() {
        return this.dataLoaded;
    }

    private void updateState() {
        if (this.mutex.isAcquired()) {
            if (this.indicatorPane.getChildren().isEmpty()) {
                this.indicatorPane.getChildren().add((Object)new CustomProgressIndicator());
            }
        } else {
            this.indicatorPane.getChildren().clear();
        }
        if (this.reloadButton != null) {
            this.reloadButton.setDisable(this.handler == null || this.mutex.isAcquired());
            this.beginButton.setDisable(this.handler == null || this.mutex.isAcquired() || this.handler.getOffset() <= 0);
            this.prevButton.setDisable(this.handler == null || this.mutex.isAcquired() || this.handler.getOffset() <= 0);
            this.nextButton.setDisable(this.handler == null || this.mutex.isAcquired() || this.handler.getData().size() < this.handler.getLimit());
        }
        if (this.handler == null || this.handler.getData().isEmpty()) {
            this.pageLabel.setText(null);
        } else {
            String message = this.reloadButton == null ? Messages.getGeneral_Paging_filter3(this.handler.getData().size()) : Messages.getGeneral_Paging_filter2(this.handler.getOffset() / this.handler.getLimit() + 1, this.handler.getOffset() + 1, this.handler.getOffset() + this.handler.getData().size());
            this.pageLabel.setText(message);
        }
    }

    private void dataChanged(ListChangeListener.Change<? extends I> change) {
        this.tableView.getItems().setAll(this.handler.getData());
        this.updateState();
        this.tableView.refresh();
    }

    String getFieldName() {
        return this.fieldName;
    }

    ObservableMutex getMutex() {
        return this.mutex;
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    public void reloadData(Integer newOffset) {
        if (this.handler == null) {
            return;
        }
        this.dataLoaded = true;
        ArrayList<Pair<String, SortOrder>> sorting = new ArrayList<Pair<String, SortOrder>>();
        for (TableColumn column : this.tableView.getSortOrder()) {
            TableColumn.SortType sortType = column.getSortType();
            sorting.add((Pair<String, SortOrder>)new Pair((Object)column.getId(), (Object)(sortType == TableColumn.SortType.ASCENDING ? SortOrder.ASC : SortOrder.DESC)));
        }
        this.handler.reloadData(newOffset == null ? this.handler.getOffset() : newOffset.intValue(), sorting);
    }
}

