/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dataview;

import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import java.util.function.Supplier;
import javafx.scene.Node;

public abstract class FilterableDataViewHandler<I, FN extends Node>
extends DataViewHandler<I> {
    private final FilteringPane<FN> filteringPane;

    protected FilterableDataViewHandler(Supplier<FN> filtersPaneSupplier, boolean collapsible) {
        this.filteringPane = new FilteringPane<FN>(filtersPaneSupplier, collapsible);
        this.filteringPane.setExpanded(true);
        this.filteringPane.setOnApply(filtersPane -> {
            if (this.getWidget() != null) {
                this.apply();
            }
        });
    }

    protected void apply() {
        this.getWidget().reloadData(0);
    }

    @Override
    void setWidget(DataViewWidget<I> value) {
        if (this.getWidget() != null) {
            this.getWidget().getAdditionalPanesContainer().getChildren().remove(this.filteringPane);
        }
        super.setWidget(value);
        if (this.getWidget() != null) {
            this.filteringPane.setMutex(this.getMutex());
            this.filteringPane.setCaption(this.getWidget().getFieldName());
            if (!this.getWidget().getAdditionalPanesContainer().getChildren().contains(this.filteringPane)) {
                this.getWidget().getAdditionalPanesContainer().getChildren().add(this.filteringPane);
            }
        }
    }

    public FilteringPane<FN> getFilteringPane() {
        return this.filteringPane;
    }
}

