/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dataview;

import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.util.Pair;

public abstract class QueryDataViewHandler<I>
extends DataViewHandler<I> {
    private static final int DEFAULT_LIMIT = 100;
    private SearchQuery baseQuery;
    private FilteringPane<?> filteringPane;
    private final List<SearchCriterion> filteringCriterions = new ArrayList<SearchCriterion>();
    private int offset;

    public void setQuery(SearchQuery value) {
        this.baseQuery = value;
        this.updateWidgetSorting();
    }

    @Override
    void setWidget(DataViewWidget<I> value) {
        super.setWidget(value);
        this.updateWidgetSorting();
        this.updateWidgetFiltering();
    }

    public <N extends Node> void setFiltering(Supplier<N> filtersPaneSupplier, Function<N, List<SearchCriterion>> criterionsSupplier) {
        if (filtersPaneSupplier == null) {
            if (this.filteringPane != null && this.getWidget() != null) {
                this.getWidget().getAdditionalPanesContainer().getChildren().remove(this.filteringPane);
            }
            return;
        }
        FilteringPane<Node> pane = new FilteringPane<Node>(filtersPaneSupplier, true);
        this.filteringPane = pane;
        pane.setOnApply(filtersPane -> {
            this.filteringCriterions.clear();
            this.filteringCriterions.addAll((Collection)criterionsSupplier.apply(filtersPane));
            if (this.getWidget() != null) {
                this.getWidget().reloadData(0);
            }
        });
        this.updateWidgetFiltering();
        pane.apply();
    }

    protected FilteringPane<?> getFilteringPane() {
        return this.filteringPane;
    }

    protected List<SearchCriterion> getFilteringCriterions() {
        return Collections.unmodifiableList(this.filteringCriterions);
    }

    private void updateWidgetSorting() {
        if (this.getWidget() == null || this.baseQuery == null || this.baseQuery.getCriteria().getOrders().isEmpty()) {
            return;
        }
        Map orders = this.baseQuery.getCriteria().getOrders();
        ArrayList<TableColumn> sortColumns = new ArrayList<TableColumn>(orders.size());
        for (TableColumn column : this.getWidget().getTableView().getColumns()) {
            SortOrder sortOrder = (SortOrder)orders.get(column.getId());
            if (sortOrder != null) {
                column.setSortType(sortOrder == SortOrder.ASC ? TableColumn.SortType.ASCENDING : TableColumn.SortType.DESCENDING);
                sortColumns.add(column);
                continue;
            }
            column.setSortType(null);
        }
        this.getWidget().getTableView().getSortOrder().setAll(sortColumns);
    }

    private void updateWidgetFiltering() {
        if (this.getWidget() == null) {
            return;
        }
        if (this.filteringPane != null) {
            this.filteringPane.setMutex(this.getMutex());
            this.filteringPane.setCaption(this.getWidget().getFieldName());
            if (!this.getWidget().getAdditionalPanesContainer().getChildren().contains(this.filteringPane)) {
                this.getWidget().getAdditionalPanesContainer().getChildren().add(this.filteringPane);
            }
        }
    }

    @Override
    protected int getLimit() {
        return this.baseQuery == null || this.baseQuery.getLimit() <= 0 ? 100 : this.baseQuery.getLimit();
    }

    @Override
    protected int getOffset() {
        return this.offset;
    }

    @Override
    protected void reloadData(int newOffset, List<Pair<String, SortOrder>> sorting) {
        try {
            SearchQuery query = (SearchQuery)XCloneHelper.clone((XCloneable)this.baseQuery);
            query.setLimit(this.getLimit());
            query.setOffset(newOffset);
            query.getCriteria().getOrders().clear();
            for (Pair<String, SortOrder> pair : sorting) {
                query.getCriteria().getOrders().put(pair.getKey(), pair.getValue());
            }
            query.getCriteria().getCriterions().addAll(this.filteringCriterions);
            Notifications.get().submitTask(() -> {
                try {
                    List<I> newData = this.executeQuery(query);
                    FxUtil.submitToFxThread(() -> {
                        this.offset = query.getOffset();
                        this.getData().setAll((Collection)newData);
                    });
                }
                catch (Exception e) {
                    ErrorHandler.handle(e);
                }
            }, this.getMutex());
        }
        catch (Exception e) {
            ErrorHandler.handle(e);
        }
    }

    protected abstract List<I> executeQuery(SearchQuery var1) throws Exception;
}

