/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.table.CustomTableView;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.LocaleWrapper;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.WrapperType;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class LocaleValueWidget
extends StackPane
implements HasViewState,
HasValue<Locale> {
    private ComboBoxWidget<LocaleWrapper> comboBox;
    private Label readonlyLabel;
    private final ObjectProperty<Locale> value = new SimpleObjectProperty((Object)this, "value");
    private boolean ignoreValueChange = false;
    private final ViewState viewState = new ViewState();
    private boolean noNulls;
    private boolean extendedCode;
    String promptText;
    private Predicate<Locale> filter = loc -> true;

    public void setExtendedCode(boolean extendedCode) {
        this.extendedCode = extendedCode;
    }

    public LocaleValueWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.promptText = this.viewState.isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
        this.getStyleClass().addAll((Object[])new String[]{"locale-value-widget", "simple-widget"});
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.value.addListener((s, o, val) -> {
            if (this.ignoreValueChange) {
                return;
            }
            this.renderValue();
        });
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> {
            this.promptText = ViewState.isImmutable(n.intValue()) ? "\u2014" : UiUtil.NULL_TEXT;
            this.updateState();
        });
    }

    public void requestFocus() {
        if (this.comboBox != null) {
            this.comboBox.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public ObjectProperty<Locale> valueProperty() {
        return this.value;
    }

    public Locale getValue() {
        return (Locale)this.value.get();
    }

    public void setValue(Locale val) {
        this.value.set((Object)val);
    }

    public void setNoNulls(boolean val) {
        this.noNulls = val;
        if (this.comboBox != null) {
            this.comboBox.setNoNulls(this.noNulls);
        }
    }

    public void setFilter(Predicate<Locale> val) {
        this.filter = Objects.requireNonNull(val);
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            if (this.comboBox != null) {
                this.comboBox = null;
            }
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.comboBox == null) {
                this.comboBox = new ComboBoxWidget(false);
                this.comboBox.setSortItems(false);
                this.comboBox.setLive(true);
                this.comboBox.setNoNulls(this.noNulls);
                this.comboBox.setItemsSupplier(() -> {
                    ArrayList<LocaleWrapper> result = new ArrayList<LocaleWrapper>();
                    ArrayList availableLocales = new ArrayList();
                    if (this.extendedCode) {
                        availableLocales.addAll(LocaleUtil.getAvailableLocalesWithCountries());
                    } else {
                        availableLocales.addAll(LocaleUtil.getAvailableLocales());
                    }
                    for (Locale locale : availableLocales) {
                        if (this.filter.test(locale)) {
                            result.add(new LocaleWrapper(WrapperType.VALUE, locale));
                        }
                        if (result.size() != 2) continue;
                        break;
                    }
                    for (Locale locale : ClientSettings.get().getUserLocales()) {
                        if (!this.filter.test(locale)) continue;
                        result.add(new LocaleWrapper(WrapperType.VALUE, locale));
                    }
                    result.add(new LocaleWrapper(WrapperType.MORE, null));
                    return result;
                });
                this.comboBox.setValueApprover(val -> {
                    if (val == null || val.getType() != WrapperType.MORE) {
                        return true;
                    }
                    this.openLocalesDialog(locale -> {
                        this.comboBox.setValue(new LocaleWrapper(WrapperType.VALUE, (Locale)locale));
                        if (locale.equals(LocaleUtil.LOCALE_EN) || locale.equals(LocaleUtil.LOCALE_RU)) {
                            return;
                        }
                        List<Locale> list = ClientSettings.get().getUserLocales();
                        list.remove(locale);
                        list.add(0, (Locale)locale);
                        while (list.size() > 3) {
                            list.remove(list.size() - 1);
                        }
                        ClientSettings.get().save();
                    });
                    return false;
                });
                this.comboBox.setConverter(new StringConverter<LocaleWrapper>(){

                    public String toString(LocaleWrapper wrapper) {
                        if (wrapper == null) {
                            return LocaleValueWidget.this.promptText;
                        }
                        if (wrapper.getType() == WrapperType.MORE) {
                            return Messages.General_More;
                        }
                        return (String)StandardRenderers.LOCALE.apply(wrapper.getLocale());
                    }

                    public LocaleWrapper fromString(String string) {
                        return null;
                    }
                });
                this.comboBox.valueProperty().addListener((s, o, n) -> {
                    this.ignoreValueChange = true;
                    this.value.setValue(n != null && n.getType() == WrapperType.VALUE ? n.getLocale() : null);
                    this.ignoreValueChange = false;
                });
                this.getChildren().setAll((Object[])new Node[]{this.comboBox});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void renderValue() {
        Locale val = (Locale)this.value.get();
        if (this.comboBox != null) {
            this.comboBox.setValue(val == null ? null : new LocaleWrapper(WrapperType.VALUE, val));
            this.comboBox.redraw();
        } else {
            this.readonlyLabel.setText(val == null ? this.promptText : (String)StandardRenderers.LOCALE.apply(val));
        }
    }

    private void openLocalesDialog(Consumer<Locale> successAction) {
        CustomTableView view = new CustomTableView();
        TableColumnSettings colSettings = new TableColumnSettings();
        colSettings.setId("locale");
        colSettings.setSortable(false);
        colSettings.setDisplayName(Messages.General_Language);
        colSettings.setRenderer(StandardRenderers.LOCALE);
        view.getColumns().add(colSettings.createColumn(loc -> loc));
        view.getItems().addAll((Collection)Suppliers.ALL_LOCALES.get().stream().filter(this.filter).sorted((loc1, loc2) -> ((String)StandardRenderers.LOCALE.apply(loc1)).compareTo((String)StandardRenderers.LOCALE.apply(loc2))).collect(Collectors.toList()));
        new Dialog().setTitle(Messages.General_Language_choosing).setBody((Node)view).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Choose, () -> successAction.accept((Locale)view.getSelectionModel().getSelectedItem()), (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)view.getSelectionModel().selectedItemProperty())).show((Node)this);
    }
}

