/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.ViewWalker;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.BaseEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class NestedEntityBoxWidget<R extends BaseEntity, N extends BaseEntity>
extends BaseEntityBoxWidget<R, NestedEntityReference<R, N>> {
    private final Class<N> nestedEntityType;
    private Consumer<RootEntityPane<?, ?>> navigationCallback;
    private Function<EntityIndex<R>, NestedEntityReference<R, N>> nestedReferenceBuilder;

    public NestedEntityBoxWidget(Class<R> rootEntityCls, Class<N> nestedEntityCls, boolean readonly) {
        super(rootEntityCls, readonly);
        this.nestedEntityType = nestedEntityCls;
        this.nestedReferenceBuilder = idx -> new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), this.nestedEntityType, idx.toString());
    }

    public void setNavigationCallback(Consumer<RootEntityPane<?, ?>> value) {
        this.navigationCallback = value;
    }

    public void setNestedReferenceBuilder(Function<EntityIndex<R>, NestedEntityReference<R, N>> value) {
        this.nestedReferenceBuilder = Objects.requireNonNull(value);
    }

    @Override
    protected void navigateTo(NestedEntityReference<R, N> ref) {
        if (ref == null) {
            return;
        }
        RootEntityEditingService service = RootEntityEditingService.get();
        if (service == null) {
            return;
        }
        service.open((EntityReference<?>)ref, false, this.navigationCallback != null ? this.navigationCallback : rep -> FxUtil.submitToFxThread(() -> ViewWalker.navigateTo(rep.getEditor(), ref.getNestedEntityUid())));
    }

    @Override
    protected NestedEntityReference<R, N> createValue(EntityIndex<R> idx) {
        return this.nestedReferenceBuilder.apply(idx);
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.emptyList();
            }

            @Override
            public String getInfo() {
                return NestedEntityBoxWidget.this.getClass().getSimpleName() + " [" + NestedEntityBoxWidget.this.getEntityType().getName() + ']' + " [" + NestedEntityBoxWidget.this.nestedEntityType.getName() + ']' + DevTools.getViewStateInfo(NestedEntityBoxWidget.this.getViewState());
            }
        };
    }
}

