/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class PopupWidget<V extends Node>
extends HBox
implements HasViewState,
DevTool {
    private Button button;
    private HyperlinkWidget hyperlink;
    private Label infoLabel;
    private V view;
    private String fieldName;
    private Consumer<Dialog> dialogConfigurator;
    private final ViewState viewState = new ViewState();
    private Runnable dialogCloseHandler;
    private String actionText;
    private String infoText;
    private final EventHandler<ActionEvent> actionHandler;
    private Supplier<Dialog> dialogFactory = () -> {
        String title = !TextUtil.isBlank((String)this.fieldName) ? this.fieldName : (!TextUtil.isBlank((String)this.actionText) ? this.actionText : (!TextUtil.isBlank((String)this.infoText) ? this.infoText : "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f"));
        Dialog dialog = new Dialog();
        dialog.setTitle(title).setBody((Node)this.view).setExpandToParent(true).setOnCloseRequest(() -> {
            if (this.dialogCloseHandler != null) {
                this.dialogCloseHandler.run();
            }
        }).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Close, () -> {
            if (this.dialogCloseHandler != null) {
                this.dialogCloseHandler.run();
            }
        });
        if (this.dialogConfigurator != null) {
            this.dialogConfigurator.accept(dialog);
        }
        return dialog;
    };

    public PopupWidget() {
        this.getStyleClass().addAll((Object[])new String[]{"popup-widget", "simple-widget"});
        this.actionHandler = evt -> {
            Dialog dialog = this.dialogFactory.get();
            dialog.show((Node)this);
        };
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> {
            if (this.view instanceof HasViewState) {
                ((HasViewState)this.view).getViewState().setState(n.intValue());
            }
        });
    }

    public void setActionText(String value) {
        this.actionText = value;
        this.updateState();
    }

    public void setInfoText(String value) {
        this.infoText = value;
        this.updateState();
    }

    public void setView(V value) {
        this.view = value;
    }

    public V getView() {
        return this.view;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public void setDialogConfigurator(Consumer<Dialog> value) {
        this.dialogConfigurator = value;
    }

    public void setDialogFactory(Supplier<Dialog> dialogFactory) {
        Objects.requireNonNull(dialogFactory, "Dialog factory is null");
        this.dialogFactory = dialogFactory;
    }

    public void setDialogCloseHandler(Runnable value) {
        this.dialogCloseHandler = value;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    private void updateState() {
        ArrayList<Object> nodes = new ArrayList<Object>();
        if (!TextUtil.isBlank((String)this.infoText)) {
            if (this.infoLabel == null) {
                this.infoLabel = new CustomLabel(this.infoText);
                this.infoLabel.setMaxWidth(Double.MAX_VALUE);
                HBox.setHgrow((Node)this.infoLabel, (Priority)Priority.ALWAYS);
            } else {
                this.infoLabel.setText(this.infoText);
            }
            nodes.add(this.infoLabel);
        } else {
            this.infoLabel = null;
        }
        if (TextUtil.isBlank((String)this.actionText)) {
            this.hyperlink = null;
            if (this.button == null) {
                this.button = new Button();
                this.button.getStyleClass().add((Object)"xtrip-button");
                HBox.setHgrow((Node)this.button, (Priority)Priority.NEVER);
                this.button.setGraphic((Node)new IconNode(StandardIconShapes.DOTS_22X14, (Styleable)this.button, StandardIconIntentions.EXPAND_BUTTON_ACTION, (Styleable)this.button));
                this.button.setOnAction(this.actionHandler);
            }
            nodes.add(this.button);
        } else {
            this.button = null;
            if (this.hyperlink == null) {
                this.hyperlink = new HyperlinkWidget();
                this.hyperlink.setMaxWidth(Double.NEGATIVE_INFINITY);
                this.hyperlink.setOnAction(this.actionHandler);
            }
            this.hyperlink.setText(this.actionText);
            nodes.add(this.hyperlink);
        }
        this.getChildren().setAll(nodes);
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.singletonList(PopupWidget.this.getView());
            }

            @Override
            public String getInfo() {
                return PopupWidget.this.getClass().getSimpleName() + DevTools.getViewStateInfo(PopupWidget.this.viewState);
            }
        };
    }
}

