/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.service.GlobalSettingsService;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class RateMoneyValueWidget
extends HBox
implements HasViewState,
HasValue<RateMoney> {
    private final SimpleObjectProperty<RateMoney> value = new SimpleObjectProperty();
    private final ViewState viewState = new ViewState();
    private Labeled readonlyNode;
    private PriceValueWidget valueWidget;
    private CurrencyValueWidget currencyWidget;
    private boolean valueIsChanging = false;
    private ChangeListener<RateMoney> listener;

    public RateMoneyValueWidget(boolean ro) {
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"rate-money-value-widget", "simple-widget"});
        this.value.addListener((s, o, n) -> this.updateReadonlyNodeText());
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    public void requestFocus() {
        if (this.valueWidget != null) {
            this.valueWidget.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    @Override
    public ObjectProperty<RateMoney> valueProperty() {
        return this.value;
    }

    public RateMoney getValue() {
        return (RateMoney)this.value.get();
    }

    public void setValue(RateMoney val) {
        this.value.set((Object)val);
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            if (this.listener != null) {
                this.value.removeListener(this.listener);
                this.listener = null;
            }
            this.valueWidget = null;
            this.currencyWidget = null;
            if (this.readonlyNode == null) {
                this.readonlyNode = new CustomLabel();
                this.readonlyNode.getStyleClass().add((Object)"value-label");
                this.readonlyNode.setMaxWidth(Double.MAX_VALUE);
                this.getChildren().setAll((Object[])new Node[]{this.readonlyNode});
                this.updateReadonlyNodeText();
            }
        } else {
            this.readonlyNode = null;
            if (this.valueWidget == null) {
                this.valueWidget = new PriceValueWidget(false){

                    @Override
                    protected void clearWidget() {
                        RateMoneyValueWidget.this.valueIsChanging = true;
                        RateMoneyValueWidget.this.valueWidget.setValue(null);
                        RateMoneyValueWidget.this.currencyWidget.setValue(null);
                        RateMoneyValueWidget.this.valueIsChanging = false;
                        RateMoneyValueWidget.this.updateValue();
                    }
                };
                HBox.setHgrow((Node)this.valueWidget, (Priority)Priority.ALWAYS);
                this.currencyWidget = new CurrencyValueWidget(false);
                this.currencyWidget.setPercentOption(true);
                this.currencyWidget.setNoNulls(true);
                this.currencyWidget.setCompactMode(true);
                Tooltip.install((Node)this.currencyWidget, (Tooltip)new Tooltip(Messages.General_Choose_currency_or_percents));
                this.getChildren().setAll((Object[])new Node[]{this.valueWidget, this.currencyWidget});
                this.valueWidget.valueProperty().addListener((source, oldValue, newValue) -> {
                    if (!this.valueIsChanging) {
                        this.updateValue();
                    }
                });
                this.currencyWidget.valueProperty().addListener((source, oldValue, newValue) -> {
                    if (!this.valueIsChanging) {
                        this.updateValue();
                    }
                });
                if (this.listener == null) {
                    this.listener = (source, oldValue, newValue) -> {
                        this.valueIsChanging = true;
                        if (newValue == null) {
                            this.valueWidget.setValue(null);
                        } else if (newValue.getMoney() != null) {
                            this.valueWidget.setValue(newValue.getMoney().getValue());
                            if (newValue.getMoney().getCurrency() != null) {
                                this.currencyWidget.setValue(newValue.getMoney().getCurrency());
                            } else {
                                this.currencyWidget.setDefaultValue();
                            }
                        } else if (newValue.getRate() != null) {
                            this.valueWidget.setValue(BigDecimal.valueOf(newValue.getRate()));
                            this.currencyWidget.setCurrencyCode("%");
                        } else {
                            this.valueWidget.setValue(null);
                            this.currencyWidget.setDefaultValue();
                        }
                        this.valueIsChanging = false;
                    };
                    FxUtil.addListener(this.value, this.listener);
                }
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    private void updateReadonlyNodeText() {
        if (this.readonlyNode == null) {
            return;
        }
        RateMoney val = (RateMoney)this.value.get();
        if (val != null) {
            if (val.getRate() != null) {
                this.readonlyNode.setText(LocaleManager.get().getCurrentLocaleData().getNumberFormat().format(val.getRate()) + " %");
            } else if (val.getMoney() != null) {
                this.readonlyNode.setText((val.getMoney().getValue() == null ? "\u2014" : LocaleManager.get().getCurrentLocaleData().getPriceFormat().format(val.getMoney().getValue())) + ' ' + (val.getMoney().getCurrency() == null ? "\u2014" : val.getMoney().getCurrency()));
            } else {
                this.readonlyNode.setText("\u2014");
            }
        } else {
            this.readonlyNode.setText("\u2014");
        }
        this.readonlyNode.pseudoClassStateChanged(Styles.EMPTY_PSEUDOCLASS, val == null);
    }

    private void updateValue() {
        if (this.currencyWidget.isPercent()) {
            BigDecimal val = (BigDecimal)this.valueWidget.valueProperty().get();
            if (val == null) {
                this.value.set(null);
                return;
            }
            RateMoney newValue = new RateMoney();
            newValue.setRate(Double.valueOf(val.doubleValue()));
            this.value.set((Object)newValue);
        } else {
            BigDecimal val = (BigDecimal)this.valueWidget.valueProperty().get();
            String curr = this.currencyWidget.getValue();
            if (val == null && curr == null) {
                this.value.set(null);
                return;
            }
            RateMoney oldValue = (RateMoney)this.value.get();
            RateMoney newValue = new RateMoney();
            newValue.setMoney(new Money());
            if (val != null) {
                newValue.getMoney().setValue(val);
            } else if (oldValue != null && oldValue.getMoney() != null) {
                newValue.getMoney().setValue(BigDecimal.ZERO);
            }
            if (curr != null) {
                newValue.getMoney().setCurrency(curr);
            } else if (oldValue != null && oldValue.getMoney() != null) {
                newValue.getMoney().setCurrency(oldValue.getMoney().getCurrency());
            } else {
                GlobalSettingsService service = GlobalSettingsService.get();
                if (service != null) {
                    newValue.getMoney().setCurrency(service.getDefaultCurrency());
                }
            }
            this.value.set((Object)newValue);
        }
    }

    public boolean hasSameValue(RateMoney val) {
        RateMoney current = (RateMoney)this.value.get();
        if (current == null && val == null) {
            return true;
        }
        if (current == null || val == null) {
            return false;
        }
        if (current.getRate() != null) {
            if (val.getRate() == null) {
                return false;
            }
            return this.valueWidget == null ? MiscUtil.equals((Object)current.getRate(), (Object)val.getRate()) : this.valueWidget.hasSameValue(BigDecimal.valueOf(val.getRate()));
        }
        if (current.getMoney() == null) {
            return val.getMoney() == null;
        }
        if (val.getMoney() == null) {
            return false;
        }
        if (!MiscUtil.equals((Object)current.getMoney().getCurrency(), (Object)val.getMoney().getCurrency())) {
            return false;
        }
        return this.valueWidget == null ? MiscUtil.equals((Object)current.getMoney().getValue(), (Object)val.getMoney().getValue()) : this.valueWidget.hasSameValue(val.getMoney().getValue());
    }
}

