/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainerColumn;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.SimpleCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateTimeValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.stage.PopupWindow;
import javafx.util.StringConverter;

abstract class BaseHistoricalWidget<T>
extends GridPane
implements HasViewState {
    private final ObservableList<HistoricalValue<T>> values = FXCollections.observableArrayList();
    private StringConverter<T> converter;
    private Node dataNode;
    private Date currentDate;
    private Button historyButton;
    private String fieldName;

    BaseHistoricalWidget() {
        this.getStyleClass().addAll((Object[])new String[]{"historical-widget", "simple-widget"});
    }

    public void requestFocus() {
        if (this.dataNode != null) {
            this.dataNode.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    public ObservableList<HistoricalValue<T>> getValues() {
        return this.values;
    }

    public void setConverter(StringConverter<T> value) {
        this.converter = value;
    }

    protected StringConverter<T> getConverter() {
        return this.converter;
    }

    protected void init(Node node, boolean readonly) {
        this.dataNode = node;
        this.historyButton = new Button();
        IconNode icon = new IconNode(StandardIconShapes.HISTORY_12x12, (Styleable)this.historyButton, StandardIconIntentions.BOX_NAVIGATE_BUTTON_ACTION, (Styleable)this.historyButton);
        this.historyButton.setGraphic((Node)icon);
        this.historyButton.getStyleClass().add((Object)"xtrip-button");
        UiUtil.setTooltip((Node)this.historyButton, Messages.General_Show_field_history);
        this.historyButton.setOnAction(e -> {
            if (this.getViewState().isImmutable()) {
                this.showHistory();
            } else {
                this.editHistory();
            }
        });
        this.resizeColumns(false);
        RowConstraints rc = new RowConstraints();
        rc.setMinHeight(Double.NEGATIVE_INFINITY);
        rc.setMaxHeight(Double.NEGATIVE_INFINITY);
        rc.setVgrow(Priority.ALWAYS);
        rc.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)rc);
        this.addRow(0, new Node[]{this.dataNode, this.historyButton});
        this.values.addListener(c -> this.forceUpdateValue((List<? extends HistoricalValue<T>>)c.getList()));
        this.getViewState().setReadonly(readonly);
        this.updateState();
        this.getViewState().stateProperty().addListener((s, o, n) -> this.updateState());
    }

    protected void updateCurrentValue(HistoricalValue<T> historicalValue) {
        this.currentDate = historicalValue == null ? null : historicalValue.getDate();
    }

    protected abstract TableWidgetColumn<HistoricalValue<T>, ?> createValueColumn();

    protected void valueChanged(T newValue) {
        boolean found = false;
        for (HistoricalValue hValue : this.values) {
            if (hValue.getDate() == null || !MiscUtil.isSameDay((Date)hValue.getDate(), (Date)new Date())) continue;
            hValue.setValue(newValue);
            found = true;
        }
        if (!found) {
            HistoricalValue created = new HistoricalValue();
            created.setValue(newValue);
            created.setDate(new Date());
            this.values.add(0, (Object)created);
        }
    }

    private void forceUpdateValue(List<? extends HistoricalValue<T>> list) {
        if (!list.isEmpty()) {
            this.currentDate = list.get(0).getDate();
            HistoricalValue<T> currentValue = list.get(0);
            for (HistoricalValue<T> historicalValue : list) {
                if (historicalValue.getDate() == null || !historicalValue.getDate().after(this.currentDate)) continue;
                this.currentDate = historicalValue.getDate();
                currentValue = historicalValue;
            }
            this.updateCurrentValue(currentValue);
        } else {
            this.currentDate = null;
            this.updateCurrentValue(null);
        }
    }

    private void updateState() {
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.getViewState().isImmutable());
        this.resizeColumns(this.getViewState().isImmutable());
    }

    private void resizeColumns(boolean shrink) {
        this.getColumnConstraints().clear();
        if (shrink) {
            ColumnConstraints cc1 = new ColumnConstraints();
            cc1.setMaxWidth(Double.NEGATIVE_INFINITY);
            cc1.setHgrow(Priority.ALWAYS);
            this.getColumnConstraints().add((Object)cc1);
            ColumnConstraints cc2 = new ColumnConstraints();
            cc2.setMinWidth(Double.NEGATIVE_INFINITY);
            cc2.setMaxWidth(Double.NEGATIVE_INFINITY);
            cc2.setHgrow(Priority.NEVER);
            this.getColumnConstraints().add((Object)cc2);
        } else {
            ColumnConstraints cc1 = new ColumnConstraints();
            cc1.setMaxWidth(Double.MAX_VALUE);
            cc1.setHgrow(Priority.ALWAYS);
            this.getColumnConstraints().add((Object)cc1);
            ColumnConstraints cc2 = new ColumnConstraints();
            cc2.setMinWidth(Double.NEGATIVE_INFINITY);
            cc2.setMaxWidth(Double.NEGATIVE_INFINITY);
            cc2.setHgrow(Priority.NEVER);
            this.getColumnConstraints().add((Object)cc2);
        }
    }

    private void showHistory() {
        DateFormat df = LocaleManager.get().getCurrentLocaleData().getDateFormat();
        CellsContainer ctr = new CellsContainer();
        ctr.getColumns().addAll((Object[])new CellsContainerColumn[]{new CellsContainerColumn(35.0), new CellsContainerColumn()});
        ArrayList<SimpleCell> cells = new ArrayList<SimpleCell>(this.values.size() * 2 + 2);
        cells.add(new SimpleCell(Messages.General_Date, SimpleCell.Style.CAPTION));
        cells.add(new SimpleCell(Messages.General_Value, SimpleCell.Style.CAPTION));
        for (HistoricalValue value : this.values) {
            cells.add(new SimpleCell(value.getDate() == null ? "\u2014" : df.format(value.getDate()), SimpleCell.Style.VALUE));
            cells.add(new SimpleCell(value.getValue() == null ? "\u2014" : (this.converter == null ? value.getValue().toString() : this.converter.toString(value.getValue())), SimpleCell.Style.VALUE));
        }
        ctr.getCells().addAll(cells);
        UiUtil.showPopup((PopupWindow)UiUtil.createPopup((Parent)ctr), (Region)this.historyButton);
    }

    private void editHistory() {
        TableWidgetController<TableWidget<HistoricalValue<T>>, HistoricalValue<T>> controller = this.createTableController();
        controller.readData(this.createTableModel());
        new Dialog().setTitle(Messages.General_Writing_history_field + " " + this.fieldName).setBody((Node)controller.getView()).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Accept, () -> {
            ArrayList pairs = new ArrayList();
            controller.writeData(pairs);
            this.values.setAll(pairs);
            this.forceUpdateValue(pairs);
        }).show((Node)this.dataNode.getParent());
    }

    private List<HistoricalValue<T>> createTableModel() {
        ArrayList<HistoricalValue<T>> pairs = new ArrayList<HistoricalValue<T>>();
        for (HistoricalValue historicalValue : this.values) {
            HistoricalValue pair = new HistoricalValue();
            pair.setDate(historicalValue.getDate());
            pair.setValue(historicalValue.getValue());
            pairs.add(pair);
        }
        return pairs;
    }

    private TableWidgetController<TableWidget<HistoricalValue<T>>, HistoricalValue<T>> createTableController() {
        final TableWidget<Object> table = new TableWidget<Object>(this.getViewState().isImmutable());
        table.setItemsProvider(() -> new HistoricalValue());
        ArrayList columns = new ArrayList();
        columns.add(this.createDateColumn());
        columns.add(this.createValueColumn());
        table.setColumns(columns);
        TableWidgetController controller = new TableWidgetController<TableWidget<HistoricalValue<T>>, HistoricalValue<T>>(){

            @Override
            public TableWidget<HistoricalValue<T>> getView() {
                return table;
            }
        };
        return controller;
    }

    private DateTimeValueWidgetColumn<HistoricalValue<T>> createDateColumn() {
        Function<HistoricalValue, LocalDateTime> getter = pair -> DateUtils.asLocalDateTime(pair.getDate());
        BiConsumer<HistoricalValue, LocalDateTime> setter = (pair, date) -> pair.setDate(DateUtils.asDate(date));
        DateTimeValueWidgetColumn<HistoricalValue<T>> column = new DateTimeValueWidgetColumn<HistoricalValue<T>>(getter, setter);
        column.setCaption(Messages.General_Date);
        column.setId("date");
        column.setPrefWidth(35.0);
        return column;
    }
}

