/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.BaseHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateTimeValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.HistoricalValue;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.scene.Node;

public class DateTimeHistoricalWidget
extends BaseHistoricalWidget<Date> {
    private final DateTimeValueWidget valueWidget;
    private boolean internalChanges = false;

    public DateTimeHistoricalWidget(boolean readonly) {
        this.getStyleClass().add((Object)"date-time-historical-widget");
        this.valueWidget = new DateTimeValueWidget(readonly);
        this.valueWidget.valueProperty().addListener((o, was, date) -> this.valueChanged(DateUtils.asDate(date)));
        this.init((Node)this.valueWidget, readonly);
        this.setConverter(StandardRenderers.DATE_TIME.createStatefulConverter(this.valueWidget.getViewState()::isReadonly));
    }

    @Override
    public ViewState getViewState() {
        return this.valueWidget.getViewState();
    }

    @Override
    protected void updateCurrentValue(HistoricalValue<Date> historicalValue) {
        this.internalChanges = true;
        super.updateCurrentValue(historicalValue);
        this.valueWidget.valueProperty().set((Object)DateUtils.asLocalDateTime((Date)historicalValue.getValue()));
        this.internalChanges = false;
    }

    @Override
    protected TableWidgetColumn<HistoricalValue<Date>, ?> createValueColumn() {
        Function<HistoricalValue, LocalDateTime> getter = pair -> DateUtils.asLocalDateTime((Date)pair.getValue());
        BiConsumer<HistoricalValue, LocalDateTime> setter = (pair, date) -> pair.setValue((Object)DateUtils.asDate(date));
        DateTimeValueWidgetColumn<HistoricalValue<Date>> column = new DateTimeValueWidgetColumn<HistoricalValue<Date>>(getter, setter);
        column.setCaption(Messages.General_Value);
        column.setId("value");
        return column;
    }

    @Override
    protected void valueChanged(Date date) {
        if (!this.internalChanges) {
            super.valueChanged(date);
        }
    }
}

