/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.groups;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.FilteringPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.BaseGroupsWidget;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ExpandedGroupsWidget<V extends Node>
extends BaseGroupsWidget<V> {
    private final VBox container;
    private FilteringPane<?> filteringPane;
    private Function<V, Pos> captionAlignmentSetter;

    protected Pos getCaptionAlignment(V view) {
        Pos result;
        if (this.captionAlignmentSetter != null && (result = this.captionAlignmentSetter.apply(view)) != null) {
            return result;
        }
        return Pos.CENTER_LEFT;
    }

    public void setCaptionAlignment(Function<V, Pos> captionAlignmentSetter) {
        this.captionAlignmentSetter = captionAlignmentSetter;
    }

    public ExpandedGroupsWidget(boolean ro) {
        super(ro);
        this.getViews().addListener(change -> FxUtil.submitToFxThread(this::renderViews));
        this.getViewState().stateProperty().addListener((s, o, n) -> this.renderViews());
        this.getStyleClass().add((Object)"expanded-groups-widget");
        this.container = new VBox();
        this.container.getStyleClass().add((Object)"views-container");
        this.setCenter((Node)this.container);
        this.renderViews();
    }

    @Override
    public V getSelectedView() {
        return null;
    }

    @Override
    public void selectView(V view) {
    }

    public <N extends Node> void setFiltering(Supplier<N> filtersPaneSupplier, Function<N, Predicate<V>> predicateSupplier, boolean collapsible) {
        FilteringPane<Node> pane = filtersPaneSupplier == null ? null : new FilteringPane<Node>(filtersPaneSupplier, collapsible);
        this.filteringPane = pane;
        if (this.filteringPane == null || !this.getViews().isEmpty()) {
            this.setTop((Node)this.filteringPane);
        }
        if (pane != null) {
            pane.setOnApply(filtersPane -> {
                Predicate predicate = (Predicate)predicateSupplier.apply(filtersPane);
                for (Node view : this.getViews()) {
                    if (predicate.test(view)) {
                        view.getProperties().remove((Object)"filteredOut");
                        continue;
                    }
                    view.getProperties().put((Object)"filteredOut", (Object)Boolean.TRUE);
                }
                this.renderViews();
                this.updateFilteringCaption();
            });
            this.updateFilteringCaption();
        } else {
            this.getViews().forEach(view -> view.getProperties().remove((Object)"filteredOut"));
            this.renderViews();
        }
        this.getViews().addListener(change -> this.updateFilteringCaption());
    }

    public void applyFiltering() {
        this.filteringPane.apply();
    }

    private void updateFilteringCaption() {
        if (this.filteringPane == null) {
            return;
        }
        long filtered = this.getViews().stream().filter(view -> !view.getProperties().containsKey((Object)"filteredOut")).count();
        this.filteringPane.setCaption(Messages.getGeneral_Paging_filter(this.getFieldName(), filtered, this.getViews().size()));
    }

    private void renderViews() {
        if (this.getViews().isEmpty()) {
            this.container.getChildren().setAll((Object[])new Node[]{this.getPlaceholderPane()});
            this.setTop(null);
            return;
        }
        this.setTop((Node)this.filteringPane);
        ArrayList<BorderPane> wrappers = new ArrayList<BorderPane>(this.getViews().size());
        int idx = 0;
        for (Node view : this.getViews()) {
            if (!view.getProperties().containsKey((Object)"filteredOut")) {
                StackPane contentPane = new StackPane(new Node[]{view});
                contentPane.getStyleClass().add((Object)"content-pane");
                BorderPane wrapper = new BorderPane((Node)contentPane);
                Label captionLabel = new Label(this.getConverter().toString(view, idx));
                BorderPane headerPane = new BorderPane((Node)captionLabel);
                BorderPane.setAlignment((Node)captionLabel, (Pos)this.getCaptionAlignment(view));
                headerPane.getStyleClass().add((Object)"header-pane");
                if (!this.getViewState().isImmutable()) {
                    headerPane.setRight(this.createControlsPanel(view));
                }
                wrapper.setTop((Node)headerPane);
                wrappers.add(wrapper);
            }
            ++idx;
        }
        this.container.getChildren().setAll(wrappers);
    }

    private Node createControlsPanel(V view) {
        ControlsPane result = new ControlsPane();
        result.setMaxHeight(Double.NEGATIVE_INFINITY);
        if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.DOWN)) {
            UiUtil.setTooltip((Node)result.addButton(ControlsPane.ButtonType.DOWN, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.doMoveDown(view)), (ObservableValue<? extends Boolean>)new BooleanBinding((Node)view){
                final /* synthetic */ Node val$view;
                {
                    this.val$view = node;
                    this.bind(new Observable[]{ExpandedGroupsWidget.this.getViews()});
                }

                protected boolean computeValue() {
                    return !ExpandedGroupsWidget.this.isMoveDownEnabled(this.val$view);
                }
            }), Messages.General_Move_group_down_to_one);
        }
        if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.UP)) {
            UiUtil.setTooltip((Node)result.addButton(ControlsPane.ButtonType.UP, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.doMoveUp(view)), (ObservableValue<? extends Boolean>)new BooleanBinding((Node)view){
                final /* synthetic */ Node val$view;
                {
                    this.val$view = node;
                    this.bind(new Observable[]{ExpandedGroupsWidget.this.getViews()});
                }

                protected boolean computeValue() {
                    return !ExpandedGroupsWidget.this.isMoveUpEnabled(this.val$view);
                }
            }), Messages.General_Move_group_up_to_one);
        }
        if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.REMOVE)) {
            UiUtil.setTooltip((Node)result.addButton(ControlsPane.ButtonType.REMOVE, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.getViews().remove((Object)view)), (ObservableValue<? extends Boolean>)new BooleanBinding((Node)view){
                final /* synthetic */ Node val$view;
                {
                    this.val$view = node;
                    this.bind(new Observable[]{ExpandedGroupsWidget.this.controlButtonsRevalidationTrigger});
                    this.bind(ExpandedGroupsWidget.this.controlButtonsCoordinator.getTriggers());
                }

                protected boolean computeValue() {
                    return !ExpandedGroupsWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.REMOVE, ExpandedGroupsWidget.this.getViews().indexOf((Object)this.val$view));
                }
            }), Messages.General_Remove_group);
        }
        if (this.controlButtonsAvailability.test(ControlsPane.ButtonType.ADD)) {
            UiUtil.setTooltip((Node)result.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.getViewFactory().createAny(newViews -> {
                if (newViews.isEmpty()) {
                    return;
                }
                int idx = this.getViews().indexOf((Object)view);
                idx = idx == -1 ? this.getViews().size() : ++idx;
                if (this.newViewHandler != null) {
                    newViews.forEach(this.newViewHandler::accept);
                }
                this.getViews().addAll(idx, newViews);
            })), (ObservableValue<? extends Boolean>)new BooleanBinding((Node)view){
                final /* synthetic */ Node val$view;
                {
                    this.val$view = node;
                    this.bind(new Observable[]{ExpandedGroupsWidget.this.controlButtonsRevalidationTrigger});
                    this.bind(ExpandedGroupsWidget.this.controlButtonsCoordinator.getTriggers());
                }

                protected boolean computeValue() {
                    return !ExpandedGroupsWidget.this.controlButtonsCoordinator.test(ControlsPane.ButtonType.ADD, ExpandedGroupsWidget.this.getViews().indexOf((Object)this.val$view));
                }
            }), Messages.General_Add_new_group);
        }
        return result;
    }
}

