/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.navigator;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorViewType;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.StandardViewTypeProvider;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;

public abstract class BaseNavigatorWidget
extends BorderPane
implements HasViewState,
DevTool {
    private static final PseudoClass READONLY_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"readonly");
    private final Collection<NavigatorViewType> supportedTypes = new ArrayList<NavigatorViewType>();
    private Consumer<Consumer<NavigatorViewType>> viewTypeProvider;
    private final PlaceholderPane placeholderPane;
    private final Label placeholder;
    private final ObservableList<Node> views = FXCollections.observableArrayList();
    protected final ViewState viewState = new ViewState();
    private String fieldName;
    private BiConsumer<NavigatorViewType, Node> callbackOnCreate;
    protected boolean suggestionsEnabled;
    protected Predicate<ControlsPane.ButtonType> emptyPaneControlButtonsCoordinator = type -> true;
    protected final BooleanProperty emptyPaneButtonsRevalidationTrigger = new SimpleBooleanProperty();
    protected Function<ControlsPane.ButtonType, String> controlButtonTooltips = bt -> {
        switch (bt) {
            case PREV: {
                return Messages.General_Show_previous_group;
            }
            case NEXT: {
                return Messages.General_Show_next_group;
            }
            case DOWN: {
                return Messages.General_Move_group_down_to_one;
            }
            case UP: {
                return Messages.General_Move_group_up_to_one;
            }
            case REMOVE: {
                return Messages.General_Remove_group;
            }
            case ADD: {
                return Messages.General_Add_new_group;
            }
        }
        return null;
    };

    public boolean isSuggestionsEnabled() {
        return this.suggestionsEnabled;
    }

    public BaseNavigatorWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.viewTypeProvider = new StandardViewTypeProvider(this);
        this.placeholderPane = new PlaceholderPane();
        this.placeholder = new Label(Messages.General_No_data);
        this.placeholderPane.setPlaceholder(this.placeholder);
        ControlsPane controlPane = new ControlsPane();
        UiUtil.setTooltip((Node)controlPane.addButton(ControlsPane.ButtonType.ADD, (EventHandler<? super MouseEvent>)((EventHandler)evt -> this.createView(null)), (ObservableValue<? extends Boolean>)new BooleanBinding(){
            {
                this.bind(new Observable[]{BaseNavigatorWidget.this.emptyPaneButtonsRevalidationTrigger});
            }

            protected boolean computeValue() {
                return !BaseNavigatorWidget.this.emptyPaneControlButtonsCoordinator.test(ControlsPane.ButtonType.ADD);
            }
        }), () -> this.controlButtonTooltips.apply(ControlsPane.ButtonType.ADD));
        controlPane.visibleProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{BaseNavigatorWidget.this.viewState.stateProperty()});
            }

            protected boolean computeValue() {
                return !BaseNavigatorWidget.this.viewState.isImmutable();
            }
        });
        this.placeholderPane.setControlsPane(controlPane);
        this.viewState.stateProperty().addListener((src, o, n) -> this.pseudoClassStateChanged(READONLY_PSEUDOCLASS, ViewState.isImmutable(n.intValue())));
    }

    public Collection<NavigatorViewType> getSupportedTypes() {
        return this.supportedTypes;
    }

    public Consumer<Consumer<NavigatorViewType>> getViewTypeProvider() {
        return this.viewTypeProvider;
    }

    public void setViewTypeProvider(Consumer<Consumer<NavigatorViewType>> value) {
        this.viewTypeProvider = Objects.requireNonNull(value);
    }

    public void setPlaceholder(String value) {
        this.placeholder.setText(value.length() > 0 ? Character.toUpperCase(value.charAt(0)) + value.substring(1) : value);
    }

    public void setControlButtonTooltips(Function<ControlsPane.ButtonType, String> value) {
        this.controlButtonTooltips = Objects.requireNonNull(value);
    }

    public void setCallbackOnCreate(BiConsumer<NavigatorViewType, Node> value) {
        this.callbackOnCreate = value;
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    public void setEmptyPaneControlButtonsCoordinator(Predicate<ControlsPane.ButtonType> value) {
        this.emptyPaneControlButtonsCoordinator = Objects.requireNonNull(value);
    }

    public Predicate<ControlsPane.ButtonType> getEmptyPaneControlButtonsCoordinator() {
        return this.emptyPaneControlButtonsCoordinator;
    }

    public ObservableList<Node> getViews() {
        return this.views;
    }

    protected Node getPlaceholderPane() {
        return this.placeholderPane;
    }

    public abstract Node getSelectedView();

    public abstract void selectView(Node var1);

    public abstract void redraw();

    public void enableSuggestions(boolean enabled) {
        this.suggestionsEnabled = enabled;
    }

    protected void createView(Node after) {
        this.viewTypeProvider.accept(viewType -> this.createView(after, (NavigatorViewType)viewType));
    }

    public void createView(Node after, NavigatorViewType viewType) {
        if (viewType == null) {
            return;
        }
        Consumer<Object> creator = configuration -> Notifications.get().submitTask(() -> {
            Node view = viewType.createViewForNewObject(configuration);
            FxUtil.submitToFxThread(() -> {
                int afterIndex;
                if (view == null) {
                    return;
                }
                if (this.callbackOnCreate != null) {
                    this.callbackOnCreate.accept(viewType, view);
                }
                int index = this.getViews().size();
                if (after != null && (afterIndex = this.getViews().indexOf((Object)after)) >= 0) {
                    index = afterIndex + 1;
                }
                this.getViews().add(index, (Object)view);
                this.redraw();
                FxUtil.submitToFxThread(() -> this.selectView(view));
            });
        }, "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445");
        Consumer<Consumer<Object>> configurator = viewType.createConfiguratorForNewObject();
        if (configurator != null) {
            configurator.accept(creator);
        } else {
            creator.accept(null);
        }
    }

    public void revalidateEmptyPaneControlButtons() {
        this.emptyPaneButtonsRevalidationTrigger.set(!this.emptyPaneButtonsRevalidationTrigger.get());
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return BaseNavigatorWidget.this.getViews();
            }

            @Override
            public String getInfo() {
                return BaseNavigatorWidget.this.getClass().getSimpleName() + DevTools.getViewStateInfo(BaseNavigatorWidget.this.viewState);
            }
        };
    }
}

