/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.navigator;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.BaseNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorViewType;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public abstract class NavigatorWidgetController<W extends BaseNavigatorWidget>
implements ViewController<W, Collection<Object>> {
    private final IdentityHashMap<Node, ViewController<Node, Object>> controllers = new IdentityHashMap();
    private boolean viewsChanged;
    private Collection<Object> data;
    private AppliedAclData aclData;
    private String parentAclId;

    protected NavigatorWidgetController() {
        ((BaseNavigatorWidget)this.getView()).getViews().addListener(change -> {
            IdentityHashMap<Node, ViewController<Node, Object>> newControllers = new IdentityHashMap<Node, ViewController<Node, Object>>();
            for (Node view : ((BaseNavigatorWidget)this.getView()).getViews()) {
                ViewController<Node, Object> controller = this.controllers.get(view);
                if (controller == null) {
                    controller = this.createOrGetController(view);
                    if (this.aclData != null) {
                        controller.enforceAcl(this.aclData, this.parentAclId);
                    }
                }
                newControllers.put(view, controller);
                controller.setReadonly(((BaseNavigatorWidget)this.getView()).getViewState().isReadonly());
            }
            this.controllers.clear();
            this.controllers.putAll(newControllers);
            this.viewsChanged = true;
        });
    }

    @Override
    public void enforceAcl(AppliedAclData acl, String parentId) {
        this.aclData = acl;
        this.parentAclId = parentId;
        this.controllers.values().forEach(controller -> controller.enforceAcl(this.aclData, this.parentAclId));
        if (!this.aclData.canEdit(this.parentAclId)) {
            ((BaseNavigatorWidget)this.getView()).getViewState().setAclNotEditable(true);
        }
    }

    @Override
    public boolean isDataAclEnforceable() {
        return this.controllers.values().stream().anyMatch(ViewController::isDataAclEnforceable);
    }

    @Override
    public void enforceDataAcl(ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        this.controllers.values().forEach(controller -> controller.enforceDataAcl(rootController, deniedPermissions));
    }

    @Override
    public Collection<Object> getData() {
        return this.data;
    }

    private NavigatorViewType getViewTypeFor(Object item) {
        for (NavigatorViewType viewType : ((BaseNavigatorWidget)this.getView()).getSupportedTypes()) {
            if (!viewType.isApplicableTo(item)) continue;
            return viewType;
        }
        return null;
    }

    @Override
    public void readData(Collection<Object> model) {
        this.data = model;
        Node newSelectedView = null;
        Node selected = ((BaseNavigatorWidget)this.getView()).getSelectedView();
        String selectedUid = selected == null ? null : (String)selected.getProperties().get((Object)"model-uid");
        ArrayList<Node> views = new ArrayList<Node>(model.size());
        for (Object item : model) {
            NavigatorViewType viewType = this.getViewTypeFor(item);
            if (viewType == null) continue;
            Node view = this.getOrCreateView(viewType, item);
            ViewController<Node, Object> controller = this.controllers.get(view);
            if (controller == null) {
                controller = this.createOrGetController(view);
                if (this.aclData != null) {
                    controller.enforceAcl(this.aclData, this.parentAclId);
                }
                controller.setReadonly(((BaseNavigatorWidget)this.getView()).getViewState().isReadonly());
                this.controllers.put(view, controller);
            }
            if (item instanceof Identity) {
                String uid = ((Identity)item).getUid();
                view.getProperties().put((Object)"model-uid", (Object)uid);
                if (MiscUtil.equals((Object)selectedUid, (Object)uid)) {
                    newSelectedView = view;
                }
            }
            controller.readData(item);
            views.add(view);
        }
        ((BaseNavigatorWidget)this.getView()).getViews().setAll(views);
        if (newSelectedView != null) {
            ((BaseNavigatorWidget)this.getView()).selectView(newSelectedView);
        }
        this.viewsChanged = false;
    }

    private Node getOrCreateView(NavigatorViewType viewType, Object item) {
        if (!(item instanceof Identity)) {
            return viewType.createViewForExistingObject();
        }
        String uid = ((Identity)item).getUid();
        if (uid != null) {
            for (Node view : ((BaseNavigatorWidget)this.getView()).getViews()) {
                if (!uid.equals(view.getProperties().get((Object)"model-uid"))) continue;
                return view;
            }
        }
        return viewType.createViewForExistingObject();
    }

    @Override
    public void writeData(Collection<Object> model) {
        ArrayList<Object> list = new ArrayList<Object>(((BaseNavigatorWidget)this.getView()).getViews().size());
        Iterator<Object> it = model.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (this.getViewTypeFor(item) == null) {
                list.add(item);
                it.remove();
                continue;
            }
            if (item instanceof Identity) continue;
            it.remove();
        }
        for (Node view : ((BaseNavigatorWidget)this.getView()).getViews()) {
            String viewUid;
            Object item;
            ViewController<Node, Object> controller = this.controllers.get(view);
            if (controller == null) {
                controller = this.createOrGetController(view);
                if (this.aclData != null) {
                    controller.enforceAcl(this.aclData, this.parentAclId);
                }
                controller.setReadonly(((BaseNavigatorWidget)this.getView()).getViewState().isReadonly());
                this.controllers.put(view, controller);
            }
            if ((item = this.getExisting(model, viewUid = (String)view.getProperties().get((Object)"model-uid"))) == null && (item = this.createItem(view)) instanceof Identity) {
                if (viewUid == null) {
                    viewUid = UUID.randomUUID().toString();
                }
                ((Identity)item).setUid(viewUid);
            }
            controller.writeData(item);
            if (item instanceof Identity) {
                view.getProperties().put((Object)"model-uid", (Object)((Identity)item).getUid());
            }
            list.add(item);
        }
        model.clear();
        model.addAll(list);
        this.viewsChanged = false;
    }

    @Override
    public boolean isReadonly() {
        return ((BaseNavigatorWidget)this.getView()).getViewState().isReadonly();
    }

    @Override
    public void setReadonly(boolean value) {
        ((BaseNavigatorWidget)this.getView()).getViewState().setReadonly(value);
        this.controllers.values().forEach(ctr -> ctr.setReadonly(value));
    }

    @Override
    public void setNotEditable(boolean notEditable) {
        ((BaseNavigatorWidget)this.getView()).getViewState().setNotEditable(notEditable);
        this.controllers.values().forEach(ctr -> ctr.setNotEditable(notEditable));
    }

    @Override
    public void setAclNotEditable(boolean aclNotEditable) {
        ((BaseNavigatorWidget)this.getView()).getViewState().setAclNotEditable(aclNotEditable);
        this.controllers.values().forEach(ctr -> ctr.setAclNotEditable(aclNotEditable));
    }

    @Override
    public boolean isDataChanged() {
        if (this.viewsChanged) {
            return true;
        }
        for (Node view : ((BaseNavigatorWidget)this.getView()).getViews()) {
            ViewController<Node, Object> controller = this.controllers.get(view);
            if (controller == null) {
                controller = this.createOrGetController(view);
                if (this.aclData != null) {
                    controller.enforceAcl(this.aclData, this.parentAclId);
                }
                controller.setReadonly(((BaseNavigatorWidget)this.getView()).getViewState().isReadonly());
                this.controllers.put(view, controller);
            }
            if (!controller.isDataChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validateData(List<Message> messages) {
        ControllersRegistry.validateData(this, messages);
        for (ViewController<Node, Object> controller : this.controllers.values()) {
            controller.validateData(messages);
        }
    }

    private Object getExisting(Collection<Object> model, String uid) {
        if (uid == null || model.isEmpty()) {
            return null;
        }
        Iterator<Object> it = model.iterator();
        while (it.hasNext()) {
            Identity item = (Identity)it.next();
            if (!uid.equals(item.getUid())) continue;
            it.remove();
            return item;
        }
        return null;
    }

    private ViewController<Node, Object> createOrGetController(Node view) {
        ViewController<Node, Object> controller = ViewController.forView(view);
        if (controller == null) {
            controller = this.createController(view);
        }
        return controller;
    }

    protected abstract ViewController<Node, Object> createController(Node var1);

    protected abstract Object createItem(Node var1);
}

