/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.navigator;

import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorViewType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.Node;

public class StandardViewType
implements NavigatorViewType {
    private final Class<?> itemType;
    private final Supplier<Consumer<Consumer<Object>>> configuratorFactoryForNewObject;
    private Function<Object, Node> viewFactoryForNewObject;
    private final Supplier<Node> viewFactoryForExistingObject;
    private final String displayName;
    private final Map<String, Object> customData = new HashMap<String, Object>();

    public StandardViewType(Class<?> itemType, Supplier<Consumer<Consumer<Object>>> configuratorFactoryForNewObject, Function<Object, Node> viewFactoryForNewObject, Supplier<Node> viewFactoryForExistingObject, String displayName) {
        this.itemType = itemType;
        this.configuratorFactoryForNewObject = configuratorFactoryForNewObject;
        this.viewFactoryForNewObject = viewFactoryForNewObject;
        this.viewFactoryForExistingObject = viewFactoryForExistingObject;
        this.displayName = displayName;
    }

    public void setViewFactoryForNewObject(Function<Object, Node> viewFactoryForNewObject) {
        this.viewFactoryForNewObject = viewFactoryForNewObject;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public boolean isApplicableTo(Object item) {
        return item.getClass().isAssignableFrom(this.itemType);
    }

    @Override
    public Consumer<Consumer<Object>> createConfiguratorForNewObject() {
        return this.configuratorFactoryForNewObject.get();
    }

    @Override
    public Node createViewForNewObject(Object configuration) {
        return this.viewFactoryForNewObject.apply(configuration);
    }

    @Override
    public Node createViewForExistingObject() {
        return this.viewFactoryForExistingObject.get();
    }

    @Override
    public Map<String, Object> getCustomData() {
        return this.customData;
    }
}

