/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.popup;

import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomToggleButton;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.SwitchControl;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.util.StringConverter;

public class BooleanValueWidget
extends StackPane
implements HasViewState,
HasValue<Boolean> {
    private final SimpleObjectProperty<Boolean> value = new SimpleObjectProperty((Object)Boolean.FALSE);
    private final boolean compactMode;
    private Label readonlyLabel;
    private CustomToggleButton falseButton;
    private CustomToggleButton trueButton;
    private SwitchControl switchControl;
    private final ViewState viewState = new ViewState();
    private StringConverter<Boolean> converter = StandardRenderers.BOOLEAN.createStatefulConverter(this.viewState::isImmutable);

    public BooleanValueWidget(boolean compact, boolean ro) {
        this.compactMode = compact;
        this.viewState.setReadonly(ro);
        this.getStyleClass().addAll((Object[])new String[]{"boolean-value-widget", "simple-widget"});
        if (this.compactMode) {
            this.getStyleClass().add((Object)"compact");
        }
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.value.addListener((obj, oldValue, newValue) -> this.renderValue());
        this.updateState();
        this.viewState.stateProperty().addListener((s, o, n) -> this.updateState());
    }

    @Override
    public ObjectProperty<Boolean> valueProperty() {
        return this.value;
    }

    public boolean getValue() {
        return (Boolean)this.value.get();
    }

    public void setValue(boolean val) {
        this.value.set((Object)val);
    }

    public void setConverter(StringConverter<Boolean> val) {
        this.converter = Objects.requireNonNull(val);
        if (this.switchControl != null) {
            this.switchControl.setConverter(this.converter);
        } else if (this.falseButton != null) {
            this.falseButton.setText(this.converter.toString((Object)Boolean.FALSE));
            this.trueButton.setText(this.converter.toString((Object)Boolean.TRUE));
        }
        this.updateState();
    }

    @Override
    public ViewState getViewState() {
        return this.viewState;
    }

    private void updateState() {
        if (this.viewState.isImmutable()) {
            this.switchControl = null;
            this.falseButton = null;
            this.trueButton = null;
            if (this.readonlyLabel == null) {
                this.readonlyLabel = new CustomLabel();
                this.readonlyLabel.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.readonlyLabel});
            }
        } else {
            this.readonlyLabel = null;
            if (this.compactMode) {
                if (this.switchControl == null) {
                    this.switchControl = new SwitchControl(this.converter);
                    this.switchControl.value.addListener((s, o, n) -> this.value.set(n));
                    this.getChildren().setAll((Object[])new Node[]{this.switchControl});
                }
            } else if (this.falseButton == null) {
                GridPane buttonsPane = new GridPane();
                ToggleGroup toggleGroup = new ToggleGroup();
                toggleGroup.selectedToggleProperty().addListener((s, o, n) -> {
                    this.value.set((Object)this.trueButton.isSelected());
                    this.trueButton.pseudoClassStateChanged(CustomToggleButton.TO_THE_LEFT_FROM_SELECTED, this.falseButton.isSelected());
                });
                this.falseButton = new CustomToggleButton(this.converter.toString((Object)Boolean.FALSE));
                this.falseButton.setMaxWidth(Double.MAX_VALUE);
                this.falseButton.setToggleGroup(toggleGroup);
                this.falseButton.getStyleClass().add((Object)"right-button");
                this.trueButton = new CustomToggleButton(this.converter.toString((Object)Boolean.TRUE));
                this.trueButton.setMaxWidth(Double.MAX_VALUE);
                this.trueButton.setToggleGroup(toggleGroup);
                this.trueButton.getStyleClass().add((Object)"left-button");
                this.falseButton.hoverProperty().addListener((obj, o, n) -> {
                    if (this.trueButton != null) {
                        this.trueButton.pseudoClassStateChanged(CustomToggleButton.TO_THE_LEFT_FROM_HOVER, n != false && this.trueButton.isSelected());
                    }
                });
                for (int i = 0; i < 2; ++i) {
                    ColumnConstraints cc = new ColumnConstraints();
                    cc.setPercentWidth(50.0);
                    buttonsPane.getColumnConstraints().add((Object)cc);
                }
                buttonsPane.addRow(0, new Node[]{this.trueButton, this.falseButton});
                this.getChildren().setAll((Object[])new Node[]{buttonsPane});
            }
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
        this.renderValue();
    }

    private void renderValue() {
        Boolean val = (Boolean)this.value.get();
        this.pseudoClassStateChanged(Styles.HIGLIGHTED_PSEUDOCLASS, val);
        if (this.readonlyLabel != null) {
            this.readonlyLabel.setText(this.converter.toString((Object)val));
        } else if (this.switchControl != null) {
            this.switchControl.value.set(val.booleanValue());
        } else if (!val.booleanValue()) {
            this.falseButton.setSelected(true);
        } else {
            this.trueButton.setSelected(true);
        }
    }
}

