/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableColumnOwner;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.scene.Node;

public abstract class TableWidgetColumn<M, N extends Node>
implements DevTool {
    private String id;
    private String caption;
    private Supplier<QuickHelp> help;
    private String fieldName;
    private Boolean notEditable;
    private Boolean aclNotEditable;
    private boolean hidden = false;
    private TableColumnOwner<M> owner;
    private Double prefWidth;
    private Double prefWidthEm;
    private Double maxWidthEm;
    private Double minWidthEm;
    private boolean notHGrowable;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String value) {
        this.caption = value;
    }

    public Supplier<QuickHelp> getHelp() {
        return this.help;
    }

    public void setHelp(Supplier<QuickHelp> value) {
        this.help = value;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String value) {
        this.fieldName = value;
    }

    protected boolean isNotEditable() {
        return this.notEditable != null ? this.notEditable.booleanValue() : this.owner.getViewState().isNotEditable();
    }

    public Boolean getNotEditable() {
        return this.notEditable;
    }

    public void setNotEditable(Boolean value) {
        this.notEditable = value;
    }

    protected boolean isAclNotEditable() {
        return this.aclNotEditable != null ? this.aclNotEditable.booleanValue() : this.owner.getViewState().isAclNotEditable();
    }

    public Boolean getAclNotEditable() {
        return this.aclNotEditable;
    }

    public void setAclNotEditable(Boolean value) {
        this.aclNotEditable = value;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean value) {
        this.hidden = value;
    }

    public N getWidget(int row) {
        return this.owner.getWidget(this, row);
    }

    public N getHiddenWidget(int row) {
        return this.owner.getHiddenWidget(this, row);
    }

    public Double getPrefWidth() {
        return this.prefWidth;
    }

    public void setPrefWidth(Double value) {
        this.prefWidth = value;
    }

    public Double getPrefWidthEm() {
        return this.prefWidthEm;
    }

    public void setPrefWidthEm(Double value) {
        this.prefWidthEm = value;
    }

    public Double getMaxWidthEm() {
        return this.maxWidthEm;
    }

    public void setMaxWidthEm(Double value) {
        this.maxWidthEm = value;
    }

    public Double getMinWidthEm() {
        return this.minWidthEm;
    }

    public void setMinWidthEm(Double value) {
        this.minWidthEm = value;
    }

    public void setNotHGrowable(boolean value) {
        this.notHGrowable = value;
    }

    public abstract N createNode();

    public abstract void readData(M var1, N var2);

    public abstract void writeData(M var1, N var2);

    public abstract void setReadonly(N var1, boolean var2);

    public abstract void setAclNotEditable(N var1);

    public abstract boolean isDataChanged(M var1, N var2);

    public boolean isNotHGrowable() {
        return this.notHGrowable;
    }

    protected TableColumnOwner<M> getOwner() {
        return this.owner;
    }

    public void setOwner(TableColumnOwner<M> value) {
        this.owner = value;
    }

    public void applyToAllRows(Consumer<N> consumer) {
        if (this.owner == null) {
            return;
        }
        int rowsCount = this.owner.getRowsCount();
        for (int i = 0; i < rowsCount; ++i) {
            consumer.accept(this.owner.getWidget(this, i));
        }
    }

    @Override
    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            @Override
            public Collection<?> getSubItems() {
                return Collections.emptyList();
            }

            @Override
            public String getInfo() {
                StringBuilder buf = new StringBuilder();
                buf.append(TableWidgetColumn.this.getClass().getSimpleName());
                if (Boolean.TRUE.equals(TableWidgetColumn.this.notEditable)) {
                    buf.append(" [not editable]");
                }
                if (Boolean.TRUE.equals(TableWidgetColumn.this.aclNotEditable)) {
                    buf.append(" [forbidden]");
                }
                if (TableWidgetColumn.this.hidden) {
                    buf.append(" [hidden]");
                }
                buf.append(" [").append(TableWidgetColumn.this.getId()).append(']');
                return buf.toString();
            }
        };
    }
}

