/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class InfoWidgetColumn<M>
extends TableWidgetColumn<M, InfoLabelWidget> {
    private final Function<M, String> getter;
    private final BiConsumer<M, String> setter;
    private String defaultText;

    public InfoWidgetColumn(Function<M, String> aGetter, BiConsumer<M, String> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setDefaultText(String value) {
        this.defaultText = value;
        this.applyToAllRows(widget -> widget.setDefaultText(this.defaultText));
    }

    @Override
    public InfoLabelWidget createNode() {
        InfoLabelWidget result = new InfoLabelWidget();
        result.setMinWidth(Double.NEGATIVE_INFINITY);
        result.setDefaultText(this.defaultText);
        return result;
    }

    @Override
    public void readData(M model, InfoLabelWidget node) {
        node.setText(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, InfoLabelWidget node) {
        this.setter.accept(model, node.getText());
    }

    @Override
    public void setReadonly(InfoLabelWidget node, boolean readonly) {
    }

    @Override
    public void setAclNotEditable(InfoLabelWidget node) {
    }

    @Override
    public boolean isDataChanged(M model, InfoLabelWidget node) {
        return false;
    }
}

