/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.LongValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class LongValueWidgetColumn<M>
extends TableWidgetColumn<M, LongValueWidget> {
    private final Function<M, Long> getter;
    private final BiConsumer<M, Long> setter;
    private Long defaultValue = 0L;

    public LongValueWidgetColumn(Function<M, Long> aGetter, BiConsumer<M, Long> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setDefaultValue(Long value) {
        this.defaultValue = value;
        this.applyToAllRows(widget -> widget.setDefaultValue(this.defaultValue));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public LongValueWidget createNode() {
        LongValueWidget result = new LongValueWidget(this.getOwner().getViewState().isReadonly());
        result.setDefaultValue(this.defaultValue);
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, LongValueWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, LongValueWidget node) {
        this.setter.accept(model, (Long)node.valueProperty().get());
    }

    @Override
    public void setReadonly(LongValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(LongValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, LongValueWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }
}

