/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class PriceValueWidgetColumn<M>
extends TableWidgetColumn<M, PriceValueWidget> {
    private final Function<M, BigDecimal> getter;
    private final BiConsumer<M, BigDecimal> setter;

    public PriceValueWidgetColumn(Function<M, BigDecimal> aGetter, BiConsumer<M, BigDecimal> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public PriceValueWidget createNode() {
        PriceValueWidget result = new PriceValueWidget(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, PriceValueWidget node) {
        node.valueProperty().set((Object)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, PriceValueWidget node) {
        this.setter.accept(model, (BigDecimal)node.valueProperty().get());
    }

    @Override
    public void setReadonly(PriceValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(PriceValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, PriceValueWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }
}

