/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class RendererWidgetColumn<M>
extends TableWidgetColumn<M, RendererWidget> {
    private final Function<M, Object> getter;
    private final BiConsumer<M, Object> setter;
    private NodeRenderer renderer;

    public RendererWidgetColumn(Function<M, Object> aGetter, BiConsumer<M, Object> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setRenderer(NodeRenderer value) {
        this.renderer = value;
        this.applyToAllRows(widget -> widget.setRenderer(this.renderer));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public RendererWidget createNode() {
        RendererWidget result = new RendererWidget(this.getOwner().getViewState().isReadonly());
        result.setRenderer(this.renderer);
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setMaxWidth(Double.MAX_VALUE);
        return result;
    }

    @Override
    public void readData(M model, RendererWidget node) {
        node.setValue(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, RendererWidget node) {
        this.setter.accept(model, node.getValue());
    }

    @Override
    public void setReadonly(RendererWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(RendererWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, RendererWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.getValue(), (Object)this.getter.apply(model));
    }
}

