/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.SimpleObjectWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.util.StringConverter;

public class SimpleObjectWidgetColumn<M, I>
extends TableWidgetColumn<M, SimpleObjectWidget<I>> {
    private final Function<M, I> getter;
    private final BiConsumer<M, I> setter;
    private I defaultValue;
    private StringConverter<I> converter;

    public SimpleObjectWidgetColumn(Function<M, I> aGetter, BiConsumer<M, I> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setConverter(StringConverter<I> value) {
        this.converter = value;
        this.applyToAllRows(widget -> widget.setConverter(this.converter));
    }

    public void setDefaultValue(I value) {
        this.defaultValue = value;
        this.applyToAllRows(widget -> widget.setDefaultValue(this.defaultValue));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public SimpleObjectWidget<I> createNode() {
        SimpleObjectWidget<I> result = new SimpleObjectWidget<I>(this.getOwner().getViewState().isReadonly(), this.converter);
        result.setDefaultValue(this.defaultValue);
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, SimpleObjectWidget<I> node) {
        node.valueProperty().set(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, SimpleObjectWidget<I> node) {
        this.setter.accept(model, node.valueProperty().get());
    }

    @Override
    public void setReadonly(SimpleObjectWidget<I> node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(SimpleObjectWidget<I> node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, SimpleObjectWidget<I> node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), this.getter.apply(model));
    }
}

