/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column;

import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class TextWidgetColumn<M>
extends TableWidgetColumn<M, TextFieldWidget> {
    private final Function<M, String> getter;
    private final BiConsumer<M, String> setter;
    private Supplier<List<String>> itemsSupplier;
    private char[] specialChars;
    private Consumer<TextFieldWidget> widgetConfigurator;

    public TextWidgetColumn(Function<M, String> aGetter, BiConsumer<M, String> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setItemsSupplier(Supplier<List<String>> value) {
        this.itemsSupplier = value;
        this.applyToAllRows(widget -> widget.setItemsSupplier(this.itemsSupplier));
    }

    public void setSpecialChars(char[] value) {
        this.specialChars = value;
        this.applyToAllRows(widget -> widget.setSpecialChars(this.specialChars));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    public void setWidgetConfigurator(Consumer<TextFieldWidget> value) {
        this.widgetConfigurator = value;
        if (this.widgetConfigurator != null) {
            this.applyToAllRows(widget -> this.widgetConfigurator.accept((TextFieldWidget)widget));
        }
    }

    @Override
    public TextFieldWidget createNode() {
        TextFieldWidget result = new TextFieldWidget(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setMaxWidth(Double.MAX_VALUE);
        result.setItemsSupplier(this.itemsSupplier);
        result.setSpecialChars(this.specialChars);
        if (this.widgetConfigurator != null) {
            this.widgetConfigurator.accept(result);
        }
        return result;
    }

    @Override
    public void readData(M model, TextFieldWidget node) {
        node.setValue(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, TextFieldWidget node) {
        this.setter.accept(model, node.getValue());
    }

    @Override
    public void setReadonly(TextFieldWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(TextFieldWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, TextFieldWidget node) {
        return !node.getViewState().isImmutable() && !node.hasSameText(this.getter.apply(model));
    }
}

