/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.historical.DateTimeHistoricalWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;

public class DateTimeHistoricalWidgetColumn<M>
extends TableWidgetColumn<M, DateTimeHistoricalWidget> {
    private final Function<M, List<HistoricalValue<Date>>> getter;

    public DateTimeHistoricalWidgetColumn(Function<M, List<HistoricalValue<Date>>> aGetter) {
        this.getter = aGetter;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public DateTimeHistoricalWidget createNode() {
        DateTimeHistoricalWidget result = new DateTimeHistoricalWidget(this.getOwner().getViewState().isReadonly());
        result.setFieldName(this.getFieldName());
        result.getViewState().setNotEditable(this.isNotEditable());
        return result;
    }

    @Override
    public void readData(M model, DateTimeHistoricalWidget node) {
        node.getValues().setAll((Collection)this.getter.apply(model));
    }

    @Override
    public void writeData(M model, DateTimeHistoricalWidget node) {
        List<HistoricalValue<Date>> list = this.getter.apply(model);
        list.clear();
        list.addAll((Collection<HistoricalValue<Date>>)node.getValues());
    }

    @Override
    public void setReadonly(DateTimeHistoricalWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(DateTimeHistoricalWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, DateTimeHistoricalWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)HistoricalValueHelper.getValue((List)node.getValues()), (Object)HistoricalValueHelper.getValue(this.getter.apply(model)));
    }
}

