/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog;

import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.LocaleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class LocaleValueWidgetColumn<M>
extends TableWidgetColumn<M, LocaleValueWidget> {
    private final Function<M, Locale> getter;
    private final BiConsumer<M, Locale> setter;
    private boolean noNulls;
    private boolean extendedCode;
    private Predicate<Locale> filter;

    public LocaleValueWidgetColumn(Function<M, Locale> aGetter, BiConsumer<M, Locale> aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
    }

    public void setNoNulls(boolean value) {
        this.noNulls = value;
        this.applyToAllRows(widget -> widget.setNoNulls(this.noNulls));
    }

    public void setExtendedCode(boolean value) {
        this.extendedCode = value;
        this.applyToAllRows(widget -> widget.setNoNulls(this.extendedCode));
    }

    public void setFilter(Predicate<Locale> value) {
        this.filter = value;
        this.applyToAllRows(widget -> widget.setFilter(this.filter));
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.getViewState().setNotEditable(this.isNotEditable()));
    }

    @Override
    public LocaleValueWidget createNode() {
        LocaleValueWidget result = new LocaleValueWidget(this.getOwner().getViewState().isReadonly());
        result.getViewState().setNotEditable(this.isNotEditable());
        result.setNoNulls(this.noNulls);
        result.setExtendedCode(this.extendedCode);
        result.setMinWidth(Double.NEGATIVE_INFINITY);
        if (this.filter != null) {
            result.setFilter(this.filter);
        }
        return result;
    }

    @Override
    public void readData(M model, LocaleValueWidget node) {
        node.setValue(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, LocaleValueWidget node) {
        this.setter.accept(model, node.getValue());
    }

    @Override
    public void setReadonly(LocaleValueWidget node, boolean readonly) {
        node.getViewState().setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(LocaleValueWidget node) {
        node.getViewState().setAclNotEditable(this.isAclNotEditable());
    }

    @Override
    public boolean isDataChanged(M model, LocaleValueWidget node) {
        return !node.getViewState().isImmutable() && !MiscUtil.equals((Object)node.valueProperty().get(), (Object)this.getter.apply(model));
    }
}

