/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.list.filter;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.layout.Pane;

class EnumFilterFactory
implements ListPaneFilterFactory {
    EnumFilterFactory() {
    }

    @Override
    public boolean isApplicableTo(TableColumnSettings settings) {
        return MetaRegistry.get().getEnums().containsKey(settings.getType());
    }

    @Override
    public FilterHandler createFor(final TableColumnSettings settings, final Supplier<List<?>> itemsSupplier) throws Exception {
        final Class type = XSHelper.getClass((String)settings.getType());
        return new FilterHandler(){
            private ComboBoxWidget<Enum> control;

            @Override
            public void reset() {
                this.control.setValue(null);
            }

            @Override
            public List<Object> getData() {
                Enum value = this.control.getValue();
                return value == null ? null : Collections.singletonList(value);
            }

            @Override
            public void setData(List<Object> value) {
                if (value.isEmpty()) {
                    this.reset();
                } else {
                    this.control.setValue((Enum)value.get(0));
                }
            }

            @Override
            public void build(Pane pane) {
                this.control = new ComboBoxWidget(false);
                if (itemsSupplier != null) {
                    this.control.setItemsSupplier(itemsSupplier);
                    this.control.setAsync(true);
                } else {
                    this.control.setItemsSupplier(Suppliers.createEnumSupplier(type));
                }
                SimpleSuggestionsHandler<Enum> suggestionsHandler = new SimpleSuggestionsHandler<Enum>(this.control.getConverter(), this.control.getItemsSupplier(), this.control.isSortItems());
                suggestionsHandler.setAsync(itemsSupplier != null);
                this.control.setSuggestionsHandler(suggestionsHandler);
                FilterHandler.buildFilter(pane, settings.getDisplayName(), this.control);
            }
        };
    }
}

