/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.list.filter;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.pair.PairWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.pair.PairWidgetHandler;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.layout.Pane;

class IntValueFilterFactory
implements ListPaneFilterFactory {
    IntValueFilterFactory() {
    }

    @Override
    public boolean isApplicableTo(TableColumnSettings settings) {
        return "int".equals(settings.getType()) || "Integer".equals(settings.getType());
    }

    @Override
    public FilterHandler createFor(final TableColumnSettings settings, Supplier<List<?>> itemsSupplier) throws Exception {
        return new FilterHandler(){
            private PairWidget<Integer, IntValueWidget> control;

            @Override
            public void reset() {
                this.control.setFirstValue(null);
                this.control.setSecondValue(null);
            }

            @Override
            public List<Object> getData() {
                if (this.control.getFirstValue() != null || this.control.getSecondValue() != null) {
                    return Arrays.asList(this.control.getFirstValue(), this.control.getSecondValue());
                }
                return null;
            }

            @Override
            public void setData(List<Object> value) {
                if (value.isEmpty()) {
                    this.reset();
                } else {
                    this.control.setFirstValue((Integer)value.get(0));
                    this.control.setSecondValue((Integer)value.get(1));
                }
            }

            @Override
            public void build(Pane pane) {
                this.control = new PairWidget<Integer, IntValueWidget>(PairWidgetHandler.INT, false);
                this.reset();
                FilterHandler.buildFilter(pane, settings.getDisplayName(), this.control);
            }
        };
    }
}

