/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.list.filter;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.list.FilterHandler;
import com.gridnine.xtrip.client.fx.core.list.ListPaneFilterFactory;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

class SimpleTextFilterFactory
implements ListPaneFilterFactory {
    SimpleTextFilterFactory() {
    }

    @Override
    public boolean isApplicableTo(TableColumnSettings settings) {
        return "String".equals(settings.getType());
    }

    @Override
    public FilterHandler createFor(final TableColumnSettings settings, final Supplier<List<?>> itemsSupplier) {
        return new FilterHandler(){
            private HasValue<String> control;

            @Override
            public void reset() {
                this.control.valueProperty().set(null);
            }

            @Override
            public List<Object> getData() {
                if (!TextUtil.isBlank((String)((String)this.control.valueProperty().get()))) {
                    return Collections.singletonList(this.control.valueProperty().get());
                }
                return null;
            }

            @Override
            public void setData(List<Object> value) {
                if (value.isEmpty()) {
                    this.reset();
                } else {
                    this.control.valueProperty().set((Object)((String)value.get(0)));
                }
            }

            @Override
            public void build(Pane pane) {
                StackPane node;
                if (itemsSupplier != null) {
                    ComboBoxWidget<String> widget = new ComboBoxWidget<String>(false);
                    widget.setItemsSupplier(itemsSupplier);
                    widget.setAsync(true);
                    SimpleSuggestionsHandler suggestionsHandler = new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems());
                    suggestionsHandler.setAsync(true);
                    widget.setSuggestionsHandler(suggestionsHandler);
                    node = widget;
                    this.control = widget;
                } else {
                    TextFieldWidget widget;
                    node = widget = new TextFieldWidget(false);
                    this.control = widget;
                }
                FilterHandler.buildFilter(pane, settings.getDisplayName(), (Node)node);
            }
        };
    }
}

