/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.property;

import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.property.PropertyRendererWidget;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class PropertyRendererWidgetColumn<M>
extends TableWidgetColumn<M, PropertyRendererWidget> {
    private final Function<M, Object> getter;
    private final BiConsumer<M, Object> setter;

    public PropertyRendererWidgetColumn(Function<M, Object> getter, BiConsumer<M, Object> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public void setNotEditable(Boolean value) {
        super.setNotEditable(value);
        this.applyToAllRows(widget -> widget.setNotEditable(this.isNotEditable()));
    }

    @Override
    public PropertyRendererWidget createNode() {
        PropertyRendererWidget result = new PropertyRendererWidget();
        result.setNotEditable(this.isNotEditable());
        result.setMinWidth(Double.NEGATIVE_INFINITY);
        result.setMaxWidth(Double.MAX_VALUE);
        return result;
    }

    @Override
    public void readData(M model, PropertyRendererWidget node) {
        node.setValue(this.getter.apply(model));
    }

    @Override
    public void writeData(M model, PropertyRendererWidget node) {
        this.setter.accept(model, node.getValue());
    }

    @Override
    public void setReadonly(PropertyRendererWidget node, boolean readonly) {
        node.setReadonly(readonly);
    }

    @Override
    public void setAclNotEditable(PropertyRendererWidget node) {
    }

    @Override
    public boolean isDataChanged(M model, PropertyRendererWidget node) {
        return !MiscUtil.equals((Object)node.getValue(), (Object)this.getter.apply(model));
    }
}

