/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.res;

import com.gridnine.xtrip.client.fx.core.res.Theme;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javafx.scene.Scene;
import javafx.scene.text.Font;
import org.java.plugin.registry.Extension;
import org.slf4j.LoggerFactory;

public final class FxRes {
    public static final String FONT_FAMILY;
    private static final Theme THEME;
    private static final List<String> KNOWN_STYLESHEETS;

    public static void addStylesheets(Scene scene) {
        FxRes.applyScaleFactor(scene, ClientSettings.get().getScaleFactor());
        scene.getStylesheets().addAll(KNOWN_STYLESHEETS);
    }

    public static Theme getTheme() {
        return THEME;
    }

    public static void applyScaleFactor(Scene scene, int factor) {
        scene.getRoot().setStyle(String.format("-fx-font-family: %s; -fx-font-size: %spt;", FONT_FAMILY, String.valueOf(UiUtil.computeFontSize(factor))));
    }

    private FxRes() {
    }

    static {
        ArrayList<String> fontsToLoad = new ArrayList<String>();
        fontsToLoad.add("Univers_Condensed-Medium-Italic.ttf");
        if (Font.getFontNames().contains("Segoe UI")) {
            FONT_FAMILY = "Segoe UI";
        } else {
            FONT_FAMILY = "PT Sans";
            fontsToLoad.addAll(Arrays.asList("PT_Sans-Web-Regular.ttf", "PT_Sans-Web-Bold.ttf", "PT_Sans-Web-Italic.ttf", "PT_Sans-Web-BoldItalic.ttf", "PTM55FT.ttf"));
        }
        fontsToLoad.forEach(fileName -> {
            try (InputStream strm = FxRes.class.getResourceAsStream("font/" + fileName);){
                if (Font.loadFont((InputStream)strm, (double)0.0) == null) {
                    LoggerFactory.getLogger(FxRes.class).warn("can't load font " + fileName);
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(FxRes.class).error("failed loading font " + fileName, (Throwable)e);
            }
        });
        List exts = JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.client.fx.core", (String)"Theme");
        if (exts.isEmpty()) {
            throw Xeption.forDeveloper((String)"no theme extension found", (Object[])new Object[0]);
        }
        Extension ext = (Extension)exts.get(exts.size() - 1);
        try {
            THEME = (Theme)JpfUtil.getClass((Extension)ext, (String)"class").newInstance();
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"failed instanciating theme from extension {0}", (Throwable)e, (Object[])new Object[]{ext});
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(THEME.getStylesheet().toExternalForm());
        for (Extension ext2 : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.client.fx.core", (String)"FxStylesheets")) {
            for (Object param : ext2.getParameters("location")) {
                try {
                    URL url = JpfUtil.getResource((Extension.Parameter)param);
                    list.add(url.toExternalForm());
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(FxRes.class).error("failed building stylesheet URL from extension " + ext2 + " and location " + param.rawValue(), (Throwable)e);
                }
            }
        }
        KNOWN_STYLESHEETS = Collections.unmodifiableList(list);
        try {
            PropertyResourceBundle bundle;
            Object param;
            String baseName = "com/sun/javafx/scene/control/skin/resources/controls";
            Locale locale = new Locale("ru", "RU");
            InputStreamReader reader = new InputStreamReader(FxRes.class.getResourceAsStream("controls_ru_RU.properties"), StandardCharsets.UTF_8);
            param = null;
            try {
                bundle = new PropertyResourceBundle(reader);
            }
            catch (Throwable e) {
                param = e;
                throw e;
            }
            finally {
                if (reader != null) {
                    if (param != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable e) {
                            ((Throwable)param).addSuppressed(e);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
            Class<?> cacheKeyClass = Class.forName("java.util.ResourceBundle$CacheKey");
            Constructor<?> cacheKeyClassConstructor = cacheKeyClass.getDeclaredConstructor(String.class, Locale.class, ClassLoader.class);
            cacheKeyClassConstructor.setAccessible(true);
            Object cacheKey = cacheKeyClassConstructor.newInstance(baseName, locale, ControlResources.class.getClassLoader());
            Method putBundleInCache = ResourceBundle.class.getDeclaredMethod("putBundleInCache", cacheKeyClass, ResourceBundle.class, ResourceBundle.Control.class);
            putBundleInCache.setAccessible(true);
            putBundleInCache.invoke(null, cacheKey, bundle, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(FxRes.class).error("failed loading FX resources translations", (Throwable)e);
        }
    }
}

