/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.settings;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Node;

public interface SettingsHandler<C extends Node, F extends Node>
extends RegistryItem<SettingsHandler<?, ?>> {
    public static final RegistryItemType<SettingsHandler<?, ?>> TYPE = new RegistryItemType("SETTINGS-HANDLER");
    public static final Comparator<SettingsHandler<?, ?>> COMPARATOR = (sett1, sett2) -> Double.compare(sett1.getWeight(), sett2.getWeight());

    public static SettingsHandler<?, ?> forId(String id) {
        return ClientRegistry.get().allOf(TYPE).get(id);
    }

    @Override
    default public RegistryItemType<SettingsHandler<?, ?>> getType() {
        return TYPE;
    }

    public double getWeight();

    public Tile<C, F> createTile(Consumer<List<Message>> var1);

    public String getAclResourceId();

    default public void enforceAcl(Tile<C, F> tile, AppliedAclData aclData) {
    }

    public void loadData(Tile<C, F> var1) throws Exception;

    public void saveData(Tile<C, F> var1) throws Exception;

    public boolean isDataChanged(Tile<C, F> var1);

    public void setNotEditable(Tile<C, F> var1, boolean var2);
}

