/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.settings;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.kb.ShortcutHandler;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.settings.SettingsAction;
import com.gridnine.xtrip.client.fx.core.settings.SettingsHandler;
import com.gridnine.xtrip.client.fx.core.settings.SettingsModificationEvent;
import com.gridnine.xtrip.client.fx.core.settings.TileEntry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.common.fx.restriction.resource.CoreUiResource;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;

public class SettingsManagerPane
extends BaseContentPane
implements ShortcutHandler {
    private final ObservableMutex mutex;
    private final TilesSpace space;
    private final Map<String, TileEntry<?, ?>> entries = new HashMap();
    private final ActionsPane<SettingsAction> actionsPane = new ActionsPane<SettingsAction>(){

        @Override
        protected boolean isDefault(SettingsAction action) {
            return false;
        }

        @Override
        protected boolean isEnabled(SettingsAction action) {
            if (SettingsManagerPane.this.getMutex().isAcquired()) {
                return false;
            }
            return action.isEnabled(SettingsManagerPane.this);
        }

        @Override
        protected void execute(Control source, SettingsAction action, boolean alt) {
            action.execute(source, SettingsManagerPane.this, alt);
        }

        @Override
        protected String getName(SettingsAction action) {
            return action.getName(SettingsManagerPane.this);
        }

        @Override
        protected String getDescription(SettingsAction action) {
            return action.getDescription(SettingsManagerPane.this);
        }

        @Override
        protected ActionIcon getIcon(SettingsAction action) {
            return action.getIcon(SettingsManagerPane.this);
        }
    };
    private final InvalidationListener acquiredListener;
    private final List<Message> validationMessages = new ArrayList<Message>();
    private final ReadOnlyBooleanWrapper ready = new ReadOnlyBooleanWrapper();
    private boolean initialized;
    private boolean dataLoaded;

    public SettingsManagerPane(ObservableMutex mtx) {
        this.mutex = mtx;
        this.getStyleClass().add((Object)"xtrip-settings-pane");
        this.space = new TilesSpace(2);
        this.actionsPane.populate(ClientRegistry.get().allOf(SettingsAction.TYPE).values().stream().filter(action -> action.isAvailable(this)).collect(Collectors.toList()));
        this.acquiredListener = obj -> this.actionsPane.revalidate();
        this.mutex.acquiredProperty().addListener(this.acquiredListener);
        this.composePane((Node)this.space, null, this.actionsPane, null);
        Notifications.get().submitTask(() -> {
            AppliedAclData aclData = AppliedAclData.load(CoreUiResource.SETTINGS.getId());
            FxUtil.submitToFxThread(() -> this.init(aclData));
        }, this.mutex);
    }

    private void init(AppliedAclData aclData) {
        ArrayList tiles = new ArrayList();
        ArrayList forbiddenTiles = new ArrayList(this.entries.size());
        ClientRegistry.get().allOf(SettingsHandler.TYPE).values().stream().sorted(SettingsHandler.COMPARATOR).forEach(handler -> {
            TileEntry entry = new TileEntry(handler, this.validationMessages::addAll);
            this.entries.put(handler.getId(), entry);
            entry.tile.expandedProperty().addListener((s, o, n) -> this.actionsPane.revalidate());
            tiles.add(entry.tile);
            if (!aclData.canView(handler.getAclResourceId())) {
                forbiddenTiles.add(entry.tile);
            } else {
                handler.setNotEditable(entry.tile, !aclData.canEdit(handler.getAclResourceId()));
                handler.enforceAcl(entry.tile, aclData);
            }
        });
        this.space.getForbiddenTiles().setAll(forbiddenTiles);
        this.space.addTiles(tiles);
        this.initialized = true;
        this.ready.set(this.initialized && this.dataLoaded);
    }

    @Override
    public void dispose() {
        this.mutex.acquiredProperty().removeListener(this.acquiredListener);
        super.dispose();
    }

    @Override
    public void handleShortcut(KeyEvent event) {
        if (this.mutex.isAcquired()) {
            return;
        }
        this.actionsPane.handleShortcut(event);
    }

    public ObservableMutex getMutex() {
        return this.mutex;
    }

    public <C extends Node, F extends Node> Tile<C, F> getTile(SettingsHandler<C, F> handler) {
        return this.entries.get((Object)handler.getId()).tile;
    }

    public TilesSpace getSpace() {
        return this.space;
    }

    public boolean isReady() {
        return this.ready.get();
    }

    public ReadOnlyBooleanProperty readyProperty() {
        return this.ready.getReadOnlyProperty();
    }

    public void reloadData() throws Exception {
        if (this.isDisposed()) {
            return;
        }
        for (TileEntry<?, ?> entry : this.entries.values()) {
            entry.handler.loadData(entry.tile);
        }
        FxUtil.submitToFxThread(() -> {
            this.dataLoaded = true;
            this.ready.set(this.initialized && this.dataLoaded);
        });
    }

    public void saveData() throws Exception {
        this.validationMessages.clear();
        ArrayList handlers = new ArrayList();
        FxUtil.waitForFxThread(() -> {
            for (SettingsHandler<?, ?> handler : ClientRegistry.get().allOf(SettingsHandler.TYPE).values()) {
                if (!handler.isDataChanged(this.getTile(handler))) continue;
                handlers.add(handler);
            }
        });
        if (handlers.isEmpty()) {
            return;
        }
        for (SettingsHandler settingsHandler : handlers) {
            settingsHandler.saveData(this.getTile(settingsHandler));
        }
        FxUtil.submitToFxThread(() -> this.space.setMessages(this.validationMessages));
        if (MessagesHelper.hasErrorMessage(this.validationMessages)) {
            Notifications.get().showFlashNotification(Messages.General_save_incomplete);
        } else {
            StandardNotifications.SAVED.show(Messages.General_System_preferences);
        }
        EventBus.get().publishAsync(new SettingsModificationEvent(handlers));
    }

    public boolean isDataChanged() {
        for (TileEntry<?, ?> entry : this.entries.values()) {
            if (!entry.handler.isDataChanged(entry.tile)) continue;
            return true;
        }
        return false;
    }
}

