/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.startup;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PasswordFieldWidget;
import com.gridnine.xtrip.client.fx.core.startup.BaseStartupForm;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiSettings;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Properties;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;

class LoginForm
extends BaseStartupForm {
    static final boolean AUTOLOGIN = "true".equalsIgnoreCase(System.getProperty("autologin"));
    final ClearableTextField userField = new ClearableTextField();
    final PasswordFieldWidget passwordField = new PasswordFieldWidget(false);
    final ClearableTextField addressField = new ClearableTextField();
    final SimpleBooleanProperty busy = new SimpleBooleanProperty();
    final Button button = new Button(Messages.General_Log_in);

    LoginForm() {
        this.userField.setPromptText(Messages.General_Login);
        this.userField.disableProperty().bind((ObservableValue)this.busy);
        this.passwordField.setPromptText(Messages.General_Password);
        this.passwordField.disableProperty().bind((ObservableValue)this.busy);
        this.addressField.setPromptText(Messages.General_Server);
        this.addressField.disableProperty().bind((ObservableValue)this.busy);
        this.setFields(new Node[]{this.userField, this.passwordField, this.addressField});
        this.userField.textProperty().addListener((observable, oldValue, newValue) -> {
            MessagePane messagePane = "system".equals(newValue) ? MessagePane.error("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u0445\u043e\u0434\u0438\u0442\u044c \u043f\u043e\u0434 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c System \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430.").setWrapText(true) : null;
            this.setMessage((Node)messagePane);
        });
        this.button.setText(Messages.General_Log_in);
        this.button.setDefaultButton(true);
        this.button.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{LoginForm.this.busy, LoginForm.this.userField.textProperty(), LoginForm.this.passwordField.valueProperty(), LoginForm.this.addressField.textProperty()});
            }

            protected boolean computeValue() {
                return LoginForm.this.busy.get() || TextUtil.isBlank((String)LoginForm.this.userField.getText()) || TextUtil.isBlank((String)LoginForm.this.passwordField.getValue()) || TextUtil.isBlank((String)LoginForm.this.addressField.getText());
            }
        });
        this.setButton(this.button);
    }

    void handleFocus() {
        String autoUpdate = System.getProperty("com.gridnine.xtrip.boot.update");
        if (autoUpdate != null) {
            try {
                this.passwordField.setValue(DesUtil.decode((String)autoUpdate));
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
        }
        Platform.runLater(() -> {
            if (TextUtil.isBlank((String)this.userField.getText())) {
                this.userField.requestFocus();
                return;
            }
            if (TextUtil.isBlank((String)this.passwordField.getValue())) {
                this.passwordField.requestFocus();
                return;
            }
            if (TextUtil.isBlank((String)this.addressField.getText())) {
                this.addressField.requestFocus();
                return;
            }
            if (autoUpdate != null || AUTOLOGIN) {
                this.button.fire();
            } else {
                this.button.requestFocus();
            }
        });
    }

    UiSettings.Persister getPersister() {
        return new UiSettings.Persister(){

            @Override
            public void write(Properties props) throws Exception {
                props.setProperty("user", LoginForm.this.userField.getText());
                props.setProperty("server", LoginForm.this.addressField.getText());
                if (AUTOLOGIN) {
                    props.setProperty("password", DesUtil.encode((String)LoginForm.this.passwordField.getValue()));
                } else {
                    props.remove("password");
                }
            }

            @Override
            public void read(Properties props) throws Exception {
                LoginForm.this.userField.setText(props.getProperty("user", ""));
                if (AUTOLOGIN) {
                    String str = props.getProperty("password", "");
                    LoginForm.this.passwordField.setValue(TextUtil.isBlank((String)str) ? "" : DesUtil.decode((String)str));
                }
                LoginForm.this.addressField.setText(props.getProperty("server", "localhost"));
            }
        };
    }
}

