/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.startup;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.startup.AdvancedLoginHandler;
import com.gridnine.xtrip.client.fx.core.startup.FxRpcServiceManager;
import com.gridnine.xtrip.client.fx.core.startup.LoginForm;
import com.gridnine.xtrip.client.fx.core.startup.StartupPane;
import com.gridnine.xtrip.client.fx.core.startup.UpdateHelper;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiSettings;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.service.AuthService;
import com.gridnine.xtrip.common.fx.rpc.service.MiscService;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.time.Instant;
import java.util.TimeZone;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LoginProcedure {
    private static final Logger log = LoggerFactory.getLogger(LoginProcedure.class);

    static void execute(StartupPane pane, Consumer<String> result) {
        ((Stage)pane.getScene().getWindow()).setTitle(Messages.General_Authorization);
        LoginForm form = new LoginForm();
        UiSettings settings = new UiSettings("login", form.getPersister());
        form.button.setOnAction(evt -> {
            settings.save();
            pane.getProgressBar().setVisible(true);
            pane.getProgressBar().setProgress(-1.0);
            form.setMessage(null);
            form.busy.set(true);
            String address = form.addressField.getText();
            String user = form.userField.getText();
            String password = form.passwordField.getValue();
            Thread thread = new Thread(() -> LoginProcedure.doLogin(pane, address, user, password, result), "login process");
            thread.setDaemon(true);
            thread.start();
        });
        settings.load();
        ErrorHandler.register(error -> {
            LoggerFactory.getLogger(LoginProcedure.class).error("login procedure failed", error);
            FxUtil.runInFxThread(() -> {
                form.setMessage((Node)MessagePane.error(ErrorHandler.getMessage(error)).setWrapText(true));
                form.busy.set(false);
                pane.getProgressBar().setVisible(false);
            });
        });
        pane.setContent(form);
        form.handleFocus();
    }

    private static void doLogin(StartupPane pane, String address, String user, String password, Consumer<String> result) {
        ValueHolder<FxRpcServiceManager> rsm = new ValueHolder<FxRpcServiceManager>();
        try {
            boolean autoUpdateMode;
            rsm.set(new FxRpcServiceManager(LoginProcedure.buildServerAddress(address)));
            Instant instant = Instant.now();
            TimeZone clientTimeZone = TimeZone.getDefault();
            TimeZone serverTimeZone = ((MiscService)((RpcServiceManager)rsm.get()).getService(MiscService.class)).getServerTimezone();
            log.info(String.format("client time zone %s (%s)", clientTimeZone.toZoneId().getId(), clientTimeZone.toZoneId().getRules().getOffset(instant)));
            log.info(String.format("server time zone %s (%s)", serverTimeZone.toZoneId().getId(), serverTimeZone.toZoneId().getRules().getOffset(instant)));
            if (!clientTimeZone.hasSameRules(serverTimeZone)) {
                log.info("client and server time zones are not match, setting server time zone");
                TimeZone.setDefault(serverTimeZone);
                clientTimeZone = TimeZone.getDefault();
                log.info(String.format("client time zone updated %s (%s)", clientTimeZone.toZoneId().getId(), clientTimeZone.toZoneId().getRules().getOffset(instant)));
            }
            ServiceInvocationContext ctx = new ServiceInvocationContext((Object)ActionSource.MIDOFFICE_CLIENT_FX);
            ctx.setLocale(LocaleManager.get().getCurrentLocale());
            if (!UpdateHelper.OLD_UPDATE_PROCEDURE) {
                ctx.setCheckSumCommonPlugins(UpdateHelper.getLocalIndex().getRpcChecksum());
            } else {
                ctx.setCheckSumCommonPlugins(UpdateIndexFile.get().getCheckSumCommonPlugins());
            }
            ctx.setSessionToken("client-" + Environment.getInstanceId());
            Serializable token = ((AuthService)((RpcServiceManager)rsm.get()).getService(AuthService.class)).login(ctx, user, password.toCharArray());
            ctx.setUser(user);
            ctx.setAuthToken(token);
            ctx.setTimezoneDataVersion(MiscUtil.getTimezoneDataVersion());
            ctx.setTimezone(System.getProperty("user.timezone"));
            ctx.setCurrentTime(System.currentTimeMillis());
            String handlerClassName = System.getProperty("client.fx.advancedLoginHandler");
            boolean bl = autoUpdateMode = System.getProperty("com.gridnine.xtrip.boot.update") != null;
            if (handlerClassName != null && !autoUpdateMode) {
                AdvancedLoginHandler handler = (AdvancedLoginHandler)Class.forName(handlerClassName).newInstance();
                FxUtil.runInFxThread(() -> {
                    pane.setContent(Messages.General_Authorization_process);
                    handler.doAdvancedLogin(pane, (RpcServiceManager)rsm.get(), ctx, password.toCharArray(), () -> LoginProcedure.loginDone((RpcServiceManager)rsm.get(), ctx, password, result));
                });
            } else {
                LoginProcedure.loginDone((RpcServiceManager)rsm.get(), ctx, password, result);
            }
        }
        catch (Exception e) {
            if (rsm.get() != null) {
                ((RpcServiceManager)rsm.get()).dispose();
            }
            ErrorHandler.handle(e);
        }
    }

    private static void loginDone(RpcServiceManager rsm, ServiceInvocationContext ctx, String password, Consumer<String> result) {
        System.setProperty("com.gridnine.xtrip.client.serverAddress", rsm.getAddress());
        Environment.publish((Object)ctx);
        Environment.publish(RpcServiceManager.class, (Object)rsm);
        FxUtil.runInFxThread(() -> result.accept(password));
    }

    private static String buildServerAddress(String alias) {
        int p;
        String result;
        String string = result = TextUtil.isBlank((String)alias) ? "localhost" : alias.trim();
        if (result.indexOf("://") == -1) {
            result = "http://" + result;
        }
        if (result.indexOf(58, p = result.indexOf("://") + 3) == -1) {
            result = result + ":8080";
        }
        return result;
    }

    private LoginProcedure() {
    }
}

