/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.startup;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconCache;
import com.gridnine.xtrip.client.fx.core.res.FxRes;
import com.gridnine.xtrip.client.fx.core.startup.LoginProcedure;
import com.gridnine.xtrip.client.fx.core.startup.PostUpdateProcedure;
import com.gridnine.xtrip.client.fx.core.startup.StartupPane;
import com.gridnine.xtrip.client.fx.core.startup.UpdateProcedure;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.java.plugin.boot.Application;

public class Startup {
    public static void execute(Application app, Stage stage, Runnable onProceed) {
        stage.setTitle(FxRes.getTheme().getTitle());
        StartupPane pane = new StartupPane();
        pane.setContent(FxRes.getTheme().getTitle());
        Scene scene = new Scene((Parent)pane);
        FxRes.addStylesheets(scene);
        IconCache.SCALE.set(UiUtil.computeScale(ClientSettings.get().getScaleFactor()));
        stage.setResizable(false);
        stage.setScene(scene);
        stage.sizeToScene();
        stage.centerOnScreen();
        stage.show();
        stage.toFront();
        Startup.loginPhase(app, pane, onProceed);
    }

    private static void loginPhase(Application app, StartupPane pane, Runnable onComplete) {
        LoginProcedure.execute(pane, password -> Startup.updatesPhase(app, pane, password, onComplete));
    }

    private static void updatesPhase(Application app, StartupPane pane, String password, Runnable onComplete) {
        UpdateProcedure.execute(app, pane, password, () -> Startup.postUpdatePhase(app, pane, onComplete));
    }

    private static void postUpdatePhase(Application app, StartupPane pane, Runnable onComplete) {
        PostUpdateProcedure.execute(app, pane, onComplete);
    }
}

