/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.startup;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.startup.CustomByteArrayOutputStream;
import com.gridnine.xtrip.client.fx.core.startup.UpdateContext;
import com.gridnine.xtrip.client.fx.core.startup.UpdateMonitor;
import com.gridnine.xtrip.client.fx.core.startup.UpdateProcedure;
import com.gridnine.xtrip.client.fx.core.startup.WorkItem;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.update.BinaryItem;
import com.gridnine.xtrip.common.fx.rpc.update.ContainerItem;
import com.gridnine.xtrip.common.fx.rpc.update.UpdateIndex;
import com.gridnine.xtrip.common.fx.rpc.update.UpdateService;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateHelper {
    static final boolean OLD_UPDATE_PROCEDURE = "true".equalsIgnoreCase(System.getProperty("client.fx.oldUpdateProcedure"));
    private static final Logger LOG = LoggerFactory.getLogger(UpdateHelper.class);
    private static UpdateIndex localIndex;
    private static final int MIN_BLOCK_SIZE = 51200;
    private static final int MAX_BLOCK_SIZE = 1024000;

    public static File getLocalIndexFile() {
        return new File(Environment.getDataFolder(), "update-repository/index.ser");
    }

    static synchronized UpdateIndex getLocalIndex() {
        if (localIndex != null) {
            return localIndex;
        }
        UpdateIndex result = null;
        File file = UpdateHelper.getLocalIndexFile();
        if (!UpdateProcedure.REPAIR && file.isFile()) {
            try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));){
                result = (UpdateIndex)in.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new UpdateIndex();
        }
        localIndex = result;
        return result;
    }

    static boolean isUpdateRequired(UpdateIndex remoteIndex) throws Exception {
        UpdateIndex localIdx = UpdateHelper.getLocalIndex();
        if (!MiscUtil.equals((Object)localIdx.getRpcChecksum(), (Object)remoteIndex.getRpcChecksum())) {
            return true;
        }
        if (localIdx.getPlugins().size() != remoteIndex.getPlugins().size()) {
            return true;
        }
        for (ContainerItem remoteItem : remoteIndex.getPlugins()) {
            ContainerItem localItem = localIdx.getPlugins().stream().filter(item -> remoteItem.getSpec().equals(item.getSpec())).findAny().orElse(null);
            if (localItem == null) {
                return true;
            }
            if (remoteItem.getEntries().isEmpty()) {
                if (MiscUtil.equals((Object)remoteItem.getChecksum(), (Object)localItem.getChecksum())) continue;
                return true;
            }
            if (remoteItem.getEntries().size() != localItem.getEntries().size()) {
                return true;
            }
            for (BinaryItem remoteEntry : remoteItem.getEntries()) {
                BinaryItem localEntry = localItem.getEntries().stream().filter(entry -> remoteEntry.getSpec().equals(entry.getSpec())).findAny().orElse(null);
                if (localEntry == null) {
                    return true;
                }
                if (remoteEntry.getSize() == localEntry.getSize() && MiscUtil.equals((Object)remoteEntry.getChecksum(), (Object)localEntry.getChecksum())) continue;
                return true;
            }
        }
        return UpdateHelper.isJREUpdateRequired(remoteIndex);
    }

    static void doUpdate(UpdateIndex remoteIndex, UpdateMonitor monitor) throws Exception {
        monitor.setProgress(Messages.General_Starting_update, 0);
        LOG.debug("update started");
        long timing = System.currentTimeMillis();
        UpdateContext ctx = new UpdateContext(remoteIndex, UpdateHelper.getLocalIndex());
        if (ctx.repositoryFolder.isDirectory()) {
            for (File file2 : ctx.repositoryFolder.listFiles(file -> !"index.ser".equals(file.getName()) && !"jre_checksum".equals(file.getName()))) {
                if (IoUtil.deleteFile((File)file2)) continue;
                throw Xeption.forEndUser((String)Messages.General_Deleting_file_failed, (Object[])new Object[]{file2});
            }
        } else if (!ctx.repositoryFolder.mkdirs()) {
            throw Xeption.forAdmin((String)Messages.General_Creating_folder_failed, (Object[])new Object[]{ctx.repositoryFolder});
        }
        UpdateHelper.phase1_actualizeLocalIndex(ctx);
        MiscUtil.logTiming((long)timing, (String)"phase 1 done");
        timing = System.currentTimeMillis();
        UpdateHelper.phase2_collectToBeDownloaded(ctx);
        MiscUtil.logTiming((long)timing, (String)"phase 2 done");
        if (LOG.isDebugEnabled()) {
            LOG.debug("to be downloaded:\n" + ctx.toBeDownloaded.stream().map(Object::toString).collect(Collectors.joining("\n")));
        }
        timing = System.currentTimeMillis();
        UpdateHelper.phase3_download(ctx, monitor);
        MiscUtil.logTiming((long)timing, (String)"phase 3 done");
        timing = System.currentTimeMillis();
        monitor.setProgress(Messages.General_Reloading_working_files, 99);
        UpdateHelper.phase4_applyUpdate(ctx);
        MiscUtil.logTiming((long)timing, (String)"phase 4 done");
        UpdateHelper.saveLocalIndex(ctx.remoteIndex);
        LOG.debug("update finished");
        monitor.setProgress(Messages.General_Updated_restart_need, 100);
    }

    private static void phase1_actualizeLocalIndex(UpdateContext ctx) throws Exception {
        ArrayList<ContainerItem> actualizedPlugins = new ArrayList<ContainerItem>();
        for (File file2 : ctx.pluginsFolder.listFiles(file -> file.isDirectory() || file.getName().toLowerCase(Locale.ROOT).endsWith(".zip"))) {
            ContainerItem localItem;
            String spec;
            if (file2.isFile()) {
                spec = file2.getName();
                localItem = ctx.localIndex.getPlugins().stream().filter(item -> spec.equals(item.getSpec())).findAny().orElse(null);
                if (localItem == null) {
                    localItem = new ContainerItem();
                    ctx.localIndex.getPlugins().add(localItem);
                    localItem.setSpec(spec);
                    localItem.setChecksum(MiscUtil.getCheckSum((URL)IoUtil.file2url((File)file2), (boolean)true));
                }
                localItem.setTimestamp(file2.lastModified());
                localItem.setSize(file2.length());
                localItem.getEntries().clear();
                actualizedPlugins.add(localItem);
                continue;
            }
            spec = file2.getName() + ".zip";
            localItem = ctx.localIndex.getPlugins().stream().filter(item -> spec.equals(item.getSpec())).findAny().orElse(null);
            if (localItem == null) {
                localItem = new ContainerItem();
                ctx.localIndex.getPlugins().add(localItem);
                localItem.setSpec(spec);
            }
            ArrayList<BinaryItem> actualizedEntries = new ArrayList<BinaryItem>();
            UpdateHelper.actualizeEntries(localItem, actualizedEntries, "", file2);
            localItem.getEntries().retainAll(actualizedEntries);
            actualizedPlugins.add(localItem);
        }
        ctx.localIndex.getPlugins().retainAll(actualizedPlugins);
        UpdateHelper.saveLocalIndex(ctx.localIndex);
    }

    private static void actualizeEntries(ContainerItem containerItem, List<BinaryItem> actualized, String parentSpec, File folder) throws Exception {
        for (File file : folder.listFiles()) {
            BinaryItem item;
            String spec;
            if (file.isDirectory()) {
                spec = parentSpec + file.getName() + '/';
                item = containerItem.getEntries().stream().filter(entry -> spec.equals(entry.getSpec())).findAny().orElse(null);
                if (item == null) {
                    item = new BinaryItem(true);
                    containerItem.getEntries().add(item);
                    item.setSpec(spec);
                }
                item.setTimestamp(file.lastModified());
                actualized.add(item);
                UpdateHelper.actualizeEntries(containerItem, actualized, item.getSpec(), file);
                continue;
            }
            spec = parentSpec + file.getName();
            item = containerItem.getEntries().stream().filter(entry -> spec.equals(entry.getSpec())).findAny().orElse(null);
            if (item == null) {
                item = new BinaryItem(false);
                containerItem.getEntries().add(item);
                item.setSpec(spec);
                try (BufferedInputStream strm = new BufferedInputStream(new FileInputStream(file));){
                    item.setChecksum(MiscUtil.getCheckSum((String)item.getSpec(), (InputStream)strm));
                }
            }
            item.setTimestamp(file.lastModified());
            item.setSize(file.length());
            actualized.add(item);
        }
    }

    private static synchronized void saveLocalIndex(UpdateIndex idx) throws Exception {
        File file = new File(Environment.getDataFolder(), "update-repository/index.ser");
        file.getParentFile().mkdirs();
        try (ObjectOutputStream strm = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            strm.writeObject(idx);
        }
        localIndex = idx;
    }

    private static void phase2_collectToBeDownloaded(UpdateContext ctx) throws Exception {
        if (UpdateHelper.isJREUpdateRequired(ctx.remoteIndex)) {
            ctx.toBeDownloaded.add(new WorkItem(ctx.remoteIndex.getJre(), null));
        }
        HashSet<String> pluginSpecs = new HashSet<String>();
        for (ContainerItem remoteItem : ctx.remoteIndex.getPlugins()) {
            pluginSpecs.add(remoteItem.getSpec());
            ContainerItem localItem = ctx.localIndex.getPlugins().stream().filter(item -> remoteItem.getSpec().equals(item.getSpec())).findAny().orElse(null);
            if (localItem == null) {
                if (remoteItem.getEntries().isEmpty()) {
                    ctx.toBeDownloaded.add(new WorkItem((BinaryItem)remoteItem, null));
                    continue;
                }
                for (BinaryItem remoteEntry : remoteItem.getEntries()) {
                    if (remoteEntry.isFolder()) continue;
                    ctx.toBeDownloaded.add(new WorkItem((BinaryItem)remoteItem, remoteEntry));
                }
                continue;
            }
            if (remoteItem.getEntries().isEmpty()) {
                if (remoteItem.getSize() == localItem.getSize() && MiscUtil.equals((Object)remoteItem.getChecksum(), (Object)localItem.getChecksum())) continue;
                ctx.toBeDownloaded.add(new WorkItem((BinaryItem)remoteItem, null));
                continue;
            }
            HashSet<String> entrySpecs = new HashSet<String>();
            for (BinaryItem remoteEntry : remoteItem.getEntries()) {
                BinaryItem localEntry;
                entrySpecs.add(remoteEntry.getSpec());
                if (remoteEntry.isFolder() || (localEntry = (BinaryItem)localItem.getEntries().stream().filter(entry -> remoteEntry.getSpec().equals(entry.getSpec())).findAny().orElse(null)) != null && remoteEntry.getSize() == localEntry.getSize() && MiscUtil.equals((Object)remoteEntry.getChecksum(), (Object)localEntry.getChecksum())) continue;
                ctx.toBeDownloaded.add(new WorkItem((BinaryItem)remoteItem, remoteEntry));
            }
        }
    }

    private static boolean isJREUpdateRequired(UpdateIndex remoteIndex) throws Exception {
        File home = new File(System.getProperty("java.home"));
        if (!new File(Environment.getRootFolder(), "jre").getCanonicalFile().equals(home.getCanonicalFile())) {
            return false;
        }
        if (remoteIndex.getJre() == null) {
            return false;
        }
        File checksumFile = new File(Environment.getDataFolder(), "update-repository/jre_checksum");
        if (!checksumFile.isFile()) {
            return true;
        }
        String jreChecksum = new String(Files.readAllBytes(checksumFile.toPath()), StandardCharsets.UTF_8);
        return !MiscUtil.equals((Object)remoteIndex.getJre().getChecksum(), (Object)jreChecksum);
    }

    private static void phase3_download(UpdateContext ctx, UpdateMonitor monitor) throws Exception {
        int totalBytesCount = 0;
        for (WorkItem item : ctx.toBeDownloaded) {
            totalBytesCount = (int)((long)totalBytesCount + (item.entry == null ? item.file.getSize() : item.entry.getSize()));
        }
        long availableSpace = 0L;
        try {
            availableSpace = Files.getFileStore(ctx.repositoryFolder.toPath()).getUnallocatedSpace();
        }
        catch (Exception e) {
            LOG.warn("failed getting disk free space", (Throwable)e);
        }
        if (availableSpace > 0L && availableSpace < (long)totalBytesCount * 3L) {
            throw Xeption.forEndUser((String)Messages.General_Not_enough_space_on_storage, (Object[])new Object[0]);
        }
        int blockSize = 51200;
        LOG.debug(String.format("block size set to %s bytes", blockSize));
        int bytesRead = 0;
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        UpdateService updateService = (UpdateService)RpcServiceManager.get().getService(UpdateService.class);
        for (WorkItem item : ctx.toBeDownloaded) {
            String name = item.getSpec();
            monitor.setProgress(Messages.General_Loading_file + ' ' + name, (int)Math.round(100.0 * (double)bytesRead / (double)totalBytesCount));
            LOG.debug("retrieving file " + name);
            File localFile = new File(ctx.repositoryFolder, name);
            localFile.getParentFile().mkdirs();
            int size = (int)(item.entry == null ? item.file.getSize() : item.entry.getSize());
            try (CustomByteArrayOutputStream baos = new CustomByteArrayOutputStream(size + 10);){
                for (int offset = 0; size > offset; offset += blockSize) {
                    long timing = System.currentTimeMillis();
                    byte[] content = updateService.getFile(sic, item.file.getSpec(), item.entry == null ? null : item.entry.getSpec(), offset, blockSize);
                    long duration = System.currentTimeMillis() - timing;
                    baos.write(content);
                    monitor.setProgress(Messages.General_Loading_file + ' ' + name, (int)Math.round(100.0 * (double)(bytesRead += content.length) / (double)totalBytesCount));
                    if (duration >= 3000L) continue;
                    if (blockSize >= 1024000) continue;
                    blockSize = Math.min((int)((double)blockSize * 1.5), 1024000);
                    LOG.debug(String.format("block size set to %s bytes \u2191", blockSize));
                }
                LOG.debug(String.format("validating content of file %s", baos.size(), name));
                String checkSum = MiscUtil.getCheckSum((String)name, (InputStream)baos.toInputStream());
                if (!MiscUtil.equals((Object)checkSum, (Object)(item.entry == null ? item.file.getChecksum() : item.entry.getChecksum()))) {
                    throw Xeption.forAdmin((String)Messages.General_Invalid_loaded_file_checksum, (Object[])new Object[]{name});
                }
                LOG.debug(String.format("saving %s bytes to file %s", baos.size(), localFile));
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(localFile));){
                    baos.writeTo(fos);
                }
            }
            localFile.setLastModified(item.entry == null ? item.file.getTimestamp() : item.entry.getTimestamp());
        }
    }

    private static void phase4_applyUpdate(UpdateContext ctx) throws Exception {
        for (File file2 : ctx.pluginsFolder.listFiles(file -> file.isDirectory() || file.getName().toLowerCase(Locale.ROOT).endsWith(".zip"))) {
            if (file2.isFile()) {
                ContainerItem remoteItem = ctx.remoteIndex.getPlugins().stream().filter(item -> item.getSpec().equals(file2.getName())).findAny().orElse(null);
                if (remoteItem != null && remoteItem.getEntries().isEmpty()) continue;
                LOG.debug("deleting file " + file2);
                IoUtil.deleteFile((File)file2);
                continue;
            }
            String spec = file2.getName() + ".zip";
            ContainerItem remoteItem = ctx.remoteIndex.getPlugins().stream().filter(item -> item.getSpec().equals(spec)).findAny().orElse(null);
            if (remoteItem == null || remoteItem.getEntries().isEmpty()) {
                LOG.debug("deleting folder " + file2);
                IoUtil.deleteFile((File)file2);
                continue;
            }
            UpdateHelper.deleteMissingEntries(remoteItem, "", file2);
        }
        for (File file2 : ctx.repositoryFolder.listFiles(file -> {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName().toLowerCase(Locale.ROOT);
            if (!name.endsWith(".zip")) {
                return false;
            }
            return ctx.remoteIndex.getJre() == null || !name.equals(ctx.remoteIndex.getJre().getSpec());
        })) {
            File dest = new File(ctx.pluginsFolder, file2.getName());
            if (file2.isDirectory()) {
                UpdateHelper.moveFolder(file2, dest);
                continue;
            }
            Files.move(file2.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (ctx.remoteIndex.getJre() == null) {
            return;
        }
        File jreFile = new File(ctx.repositoryFolder, ctx.remoteIndex.getJre().getSpec());
        if (!jreFile.isFile()) {
            return;
        }
        File jreFolder = new File(Environment.getRootFolder(), "jre_update");
        LOG.debug(String.format("unpacking JRE file %s to folder %s", jreFile, jreFolder));
        if (jreFolder.exists()) {
            IoUtil.deleteFile((File)jreFolder);
        }
        try (ZipFile zipFile = new ZipFile(jreFile);){
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String name = entry.getName();
                File entryFile = new File(jreFolder.getCanonicalPath() + '/' + name);
                if (name.endsWith("/")) {
                    if (!entryFile.exists() && !entryFile.mkdirs()) {
                        throw new IOException("can't create folder " + entryFile);
                    }
                } else {
                    File folder = entryFile.getParentFile();
                    if (!folder.exists() && !folder.mkdirs()) {
                        throw new IOException("can't create folder " + folder);
                    }
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryFile, false));
                         InputStream in = zipFile.getInputStream(entry);){
                        IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)1024);
                    }
                }
                entryFile.setLastModified(entry.getTime());
            }
        }
        catch (Exception e) {
            IoUtil.deleteFile((File)jreFolder);
            throw e;
        }
        LOG.debug("deleting file " + jreFile);
        jreFile.delete();
        LOG.debug("writing JRE checksum file");
        Files.write(new File(Environment.getDataFolder(), "update-repository/jre_checksum").toPath(), ctx.remoteIndex.getJre().getChecksum().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void deleteMissingEntries(ContainerItem item, String spec, File folder) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                UpdateHelper.deleteMissingEntries(item, spec + file.getName() + '/', file);
                continue;
            }
            if (item.getEntries().stream().filter(entry -> entry.getSpec().equals(spec + file.getName())).findAny().orElse(null) != null) continue;
            LOG.debug("deleting file " + file);
            IoUtil.deleteFile((File)file);
        }
        if (folder.listFiles().length == 0 && item.getEntries().stream().filter(entry -> entry.getSpec().equals(spec)).findAny().orElse(null) == null) {
            LOG.debug("deleting folder " + folder);
            folder.delete();
        }
    }

    private static void moveFolder(File src, File dest) throws Exception {
        dest.mkdirs();
        for (File file : src.listFiles()) {
            File target = new File(dest, file.getName());
            if (file.isDirectory()) {
                UpdateHelper.moveFolder(file, target);
                continue;
            }
            Files.move(file.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        src.delete();
    }

    private UpdateHelper() {
    }
}

