/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.startup;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.startup.AutoUpdate;
import com.gridnine.xtrip.client.fx.core.startup.BaseStartupForm;
import com.gridnine.xtrip.client.fx.core.startup.StartupPane;
import com.gridnine.xtrip.client.fx.core.startup.UpdateHelper;
import com.gridnine.xtrip.client.fx.core.startup.UpdateMonitor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.update.UpdateIndex;
import com.gridnine.xtrip.common.fx.rpc.update.UpdateService;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.update.RemoteUpdateHelper;
import com.gridnine.xtrip.common.update.UpdateEntry;
import com.gridnine.xtrip.common.update.UpdateFile;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.common.update.UpdateItem;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javafx.scene.Node;
import javafx.stage.Stage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.java.plugin.boot.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UpdateProcedure {
    private static final boolean SKIP_VERSIONS_CHECK = MiscUtil.isTrue((String)System.getProperty("rpc.skipVersionsCheck"));
    static final boolean REPAIR = MiscUtil.isTrue((String)System.getProperty("com.gridnine.xtrip.boot.repair"));
    private static final Logger LOG = LoggerFactory.getLogger(UpdateProcedure.class);

    static void execute(Application app, StartupPane pane, String password, Runnable onProceed) {
        ((Stage)pane.getScene().getWindow()).setTitle(Messages.General_Vershion_checking);
        pane.setContent(Messages.General_Vershion_checking);
        pane.getProgressBar().setVisible(true);
        pane.getProgressBar().setProgress(-1.0);
        ErrorHandler.register(error -> {
            LOG.error("update procedure failed", error);
            FxUtil.runInFxThread(() -> {
                pane.getProgressBar().setVisible(false);
                pane.getHintLabel().setVisible(false);
                ((Stage)pane.getScene().getWindow()).setOnCloseRequest(null);
                pane.setContent(new BaseStartupForm(){
                    {
                        this.setMessage((Node)MessagePane.error(ErrorHandler.getMessage(error)).setWrapText(true));
                    }
                });
            });
        });
        Thread thread = new Thread(() -> {
            try {
                UpdateProcedure.doCheck(app, pane, password, onProceed);
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
        }, "update process");
        thread.setDaemon(true);
        thread.start();
    }

    private static void doCheck(Application app, StartupPane pane, String password, Runnable onProceed) throws Exception {
        if (!UpdateHelper.OLD_UPDATE_PROCEDURE) {
            UpdateIndex remoteIndex = ((UpdateService)RpcServiceManager.get().getService(UpdateService.class)).getIndex(ServiceInvocationContext.get());
            if (!(REPAIR || !SKIP_VERSIONS_CHECK && UpdateHelper.isUpdateRequired(remoteIndex))) {
                FxUtil.runInFxThread(() -> onProceed.run());
                return;
            }
            FxUtil.waitForFxThread(() -> {
                ((Stage)pane.getScene().getWindow()).setTitle(Messages.General_Updating);
                pane.setContent(Messages.General_Updating_App);
                pane.getHintLabel().setVisible(true);
                pane.getProgressBar().setProgress(0.0);
                ((Stage)pane.getScene().getWindow()).setOnCloseRequest(evt -> evt.consume());
            });
            UpdateHelper.doUpdate(remoteIndex, (message, progress) -> FxUtil.runInFxThread(() -> {
                pane.getHintLabel().setText(message);
                pane.getProgressBar().setProgress(progress == 0 ? 0.0 : (double)progress / 100.0);
            }));
            FxUtil.waitForFxThread(() -> ((Stage)pane.getScene().getWindow()).setOnCloseRequest(null));
            if (System.getProperty("com.gridnine.xtrip.boot.init") != null) {
                AutoUpdate.restart(app, Collections.singletonMap("com.gridnine.xtrip.boot.update", DesUtil.encode((String)password)));
            }
            return;
        }
        UpdateIndexFile remoteIndexFile = ((com.gridnine.xtrip.common.fx.rpc.service.UpdateService)RpcServiceManager.get().getService(com.gridnine.xtrip.common.fx.rpc.service.UpdateService.class)).getUpdateIndexFile(ServiceInvocationContext.get());
        UpdateIndexFile localIndexFile = UpdateIndexFile.get();
        if (SKIP_VERSIONS_CHECK || MiscUtil.equals((Object)localIndexFile.getCheckSumCommonPlugins(), (Object)remoteIndexFile.getCheckSumCommonPlugins()) && MiscUtil.equals((Object)localIndexFile.getCheckSumClientPlugins(), (Object)remoteIndexFile.getCheckSumClientPlugins()) && !RemoteUpdateHelper.idModifiedJRE((UpdateIndexFile)remoteIndexFile, (UpdateIndexFile)localIndexFile)) {
            FxUtil.runInFxThread(() -> onProceed.run());
            return;
        }
        FxUtil.waitForFxThread(() -> {
            ((Stage)pane.getScene().getWindow()).setTitle(Messages.General_Updating);
            pane.setContent(Messages.General_Updating_App);
            pane.getHintLabel().setVisible(true);
            pane.getProgressBar().setProgress(0.0);
            ((Stage)pane.getScene().getWindow()).setOnCloseRequest(evt -> evt.consume());
        });
        UpdateProcedure.doUpdate(remoteIndexFile, localIndexFile, (message, progress) -> FxUtil.runInFxThread(() -> {
            pane.getHintLabel().setText(message);
            pane.getProgressBar().setProgress(progress == 0 ? 0.0 : (double)progress / 100.0);
        }));
        FxUtil.waitForFxThread(() -> ((Stage)pane.getScene().getWindow()).setOnCloseRequest(null));
        if (System.getProperty("com.gridnine.xtrip.boot.init") != null) {
            AutoUpdate.restart(app, Collections.singletonMap("com.gridnine.xtrip.boot.update", DesUtil.encode((String)password)));
        }
    }

    private static void doUpdate(UpdateIndexFile remoteIndexFile, UpdateIndexFile localIndexFile, UpdateMonitor monitor) throws Exception {
        LOG.debug("starting update");
        monitor.setProgress(Messages.General_Starting_update, 0);
        final File repository = new File(Environment.getDataFolder(), "update-repository/");
        LOG.debug("local reository is " + repository);
        File pluginsDir = new File(Environment.getRootFolder(), "plugins/");
        LOG.debug("plugins directory is " + pluginsDir);
        if (!repository.exists()) {
            if (!repository.mkdirs()) {
                throw Xeption.forAdmin((String)Messages.General_Creating_folder_for_local_storage_failed, (Object[])new Object[]{repository});
            }
            if (System.getProperty("com.gridnine.xtrip.client.copyFromPlugins") == null) {
                LOG.debug(String.format("repository [%s] is empty copying data for plugins [%s]", repository, pluginsDir));
                FileUtils.copyDirectory((File)pluginsDir, (File)repository);
            }
        }
        ArrayList<File> filesToRemove = new ArrayList<File>();
        ArrayList filesToAdd = new ArrayList();
        ArrayList<File> localFileList = new ArrayList<File>();
        for (File file : repository.listFiles()) {
            filesToRemove.add(file);
            localFileList.add(file);
        }
        HashSet<UpdateFile> remoteFiles = new HashSet<UpdateFile>();
        String osName = System.getProperties().getProperty("os.name");
        String pattern = TextUtil.isBlank((String)osName) || osName.toLowerCase().contains("windows") ? "nix" : "win";
        for (UpdateFile file : remoteIndexFile.getCommonPlugins()) {
            if (file.getName().toLowerCase().contains(pattern)) continue;
            remoteFiles.add(file);
        }
        for (UpdateFile file : remoteIndexFile.getClientPlugins()) {
            String fileName = file.getName().toLowerCase();
            if (!fileName.contains("client.fx") || fileName.contains(pattern)) continue;
            remoteFiles.add(file);
        }
        boolean bl = RemoteUpdateHelper.idModifiedJRE((UpdateIndexFile)remoteIndexFile, (UpdateIndexFile)localIndexFile);
        if (bl) {
            filesToAdd.add(remoteIndexFile.getClientJRE().get(0));
        }
        boolean pluginsAsZip = "false".equals(System.getProperty("midoffice.update.enhanced"));
        long timing = System.currentTimeMillis();
        for (UpdateFile remoteFile : remoteFiles) {
            if (remoteFile.getEntries() == null || remoteFile.getEntries().isEmpty() || pluginsAsZip) {
                File localFile = RemoteUpdateHelper.findFile(localFileList, (UpdateFile)remoteFile);
                if (localFile != null) {
                    filesToRemove.remove(localFile);
                    continue;
                }
                filesToAdd.add(remoteFile);
                continue;
            }
            RemoteUpdateHelper.collectModifiedFiles(localFileList, (UpdateFile)remoteFile, filesToAdd, filesToRemove);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("modifications collected in %d ms", System.currentTimeMillis() - timing));
        }
        LOG.debug("deleting obsolete files");
        monitor.setProgress(Messages.General_Deleting_old_files, 0);
        for (File file : filesToRemove) {
            LOG.debug("deleting file " + file);
            FileUtils.forceDelete((File)file);
        }
        int var = 0;
        for (UpdateItem file : filesToAdd) {
            var = (int)((long)var + file.getSize());
        }
        int totalBytesCount = var;
        int portion = 50000;
        int bytesRead = 0;
        int filesCount = filesToAdd.size();
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        com.gridnine.xtrip.common.fx.rpc.service.UpdateService updateService = (com.gridnine.xtrip.common.fx.rpc.service.UpdateService)RpcServiceManager.get().getService(com.gridnine.xtrip.common.fx.rpc.service.UpdateService.class);
        for (int n = 0; n < filesCount; ++n) {
            File localFile;
            UpdateItem file = (UpdateItem)filesToAdd.get(n);
            UpdateEntry entry = file instanceof UpdateEntry ? (UpdateEntry)file : null;
            String name = entry != null ? entry.getParent().getName() + '/' + entry.getName() : file.getName();
            monitor.setProgress(Messages.General_Loading_file + ' ' + name, (int)Math.round(100.0 * (double)bytesRead / (double)totalBytesCount));
            LOG.debug("retrieving file " + name);
            File file2 = localFile = null == entry ? new File(repository, file.getName()) : new File(new File(repository, FilenameUtils.getBaseName((String)entry.getParent().getName())), entry.getName());
            if (entry != null && entry.isDirectory()) {
                FileUtils.forceMkdir((File)localFile);
                continue;
            }
            File parentLocalFile = localFile.getParentFile();
            if (!parentLocalFile.exists()) {
                FileUtils.forceMkdir((File)parentLocalFile);
            }
            int offset = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (file.getSize() > (long)offset) {
                byte[] content = null == entry ? updateService.getFile(sic, file.getName(), offset, portion) : updateService.getFile(sic, entry.getParent().getName(), entry.getName(), offset, portion);
                baos.write(content);
                offset += portion;
                monitor.setProgress(Messages.General_Loading_file + ' ' + name, (int)Math.round(100.0 * (double)(bytesRead += content.length) / (double)totalBytesCount));
            }
            LOG.debug(String.format("copying content of size %s to file %s", baos.size(), localFile));
            try (FileOutputStream fos = new FileOutputStream(localFile);){
                fos.write(baos.toByteArray());
            }
            localFile.setLastModified(file.getModified().getTime());
            String checkSum = MiscUtil.getCheckSum((URL)IoUtil.file2url((File)localFile), (boolean)true);
            if (MiscUtil.equals((Object)checkSum, (Object)file.getCheckSum())) continue;
            throw Xeption.forAdmin((String)Messages.General_Invalid_loaded_file_checksum, (Object[])new Object[]{name});
        }
        monitor.setProgress(Messages.General_Reloading_working_files, 99);
        RemoteUpdateHelper.updateFileSizes((UpdateIndexFile)remoteIndexFile, (File)repository);
        LOG.debug("updating working directory");
        timing = System.currentTimeMillis();
        IoUtil.synchronizeFolders((File)repository, (File)pluginsDir, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.getParentFile().equals(repository)) {
                    return true;
                }
                String fileName = pathname.getName();
                return fileName.contains(".client") || fileName.contains(".common");
            }
        });
        if (bl) {
            LOG.debug("extract jre " + ((UpdateFile)remoteIndexFile.getClientJRE().get(0)).getName());
            File destFolder = new File(Environment.getRootFolder(), "jre_update");
            File jreFile = new File(repository, ((UpdateFile)remoteIndexFile.getClientJRE().get(0)).getName());
            try (ZipFile zipFile = new ZipFile(jreFile);){
                Enumeration<? extends ZipEntry> en = zipFile.entries();
                while (en.hasMoreElements()) {
                    ZipEntry entry = en.nextElement();
                    String name = entry.getName();
                    File entryFile = new File(destFolder.getCanonicalPath() + '/' + name);
                    if (name.endsWith("/")) {
                        if (!entryFile.exists() && !entryFile.mkdirs()) {
                            throw new IOException("can't create folder " + entryFile);
                        }
                    } else {
                        File folder = entryFile.getParentFile();
                        if (!folder.exists() && !folder.mkdirs()) {
                            throw new IOException("can't create folder " + folder);
                        }
                        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(entryFile, false));
                             InputStream in = zipFile.getInputStream(entry);){
                            IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)1024);
                        }
                    }
                    entryFile.setLastModified(entry.getTime());
                }
            }
            LOG.debug("deleting file " + jreFile);
            FileUtils.forceDelete((File)jreFile);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("working directory updated in %d ms", System.currentTimeMillis() - timing));
        }
        File indexFile = new File(repository, "index.xml");
        LOG.debug("saving index file " + indexFile);
        remoteIndexFile.saveToXml(indexFile);
        monitor.setProgress(Messages.General_Updated_restart_need, 100);
    }

    private UpdateProcedure() {
    }
}

