/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.tasks;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.CustomProgressIndicator;
import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.TerminationType;
import com.gridnine.xtrip.client.fx.core.tasks.BaseNotificationItem;
import com.gridnine.xtrip.client.fx.core.tasks.ErrorNotificationItem;
import com.gridnine.xtrip.client.fx.core.tasks.MessageNotificationItem;
import com.gridnine.xtrip.client.fx.core.tasks.SimpleNotificationItem;
import com.gridnine.xtrip.client.fx.core.tasks.SystemTaskNotificationItem;
import com.gridnine.xtrip.client.fx.core.tasks.UserTaskNotificationItem;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Duration;

public class NotificationPane
extends VBox {
    private static final int VISIBLE_ITEMS_LIMIT = 3;
    final VBox itemsPane;
    final HeaderPane headerPane;

    public NotificationPane() {
        this.getStyleClass().add((Object)"xtrip-notification-pane");
        this.itemsPane = new VBox();
        this.itemsPane.getStyleClass().add((Object)"items-pane");
        this.visibleProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{NotificationPane.this.itemsPane.getChildren()});
            }

            protected boolean computeValue() {
                return NotificationPane.this.itemsPane.getChildren().size() > 0;
            }
        });
        this.headerPane = new HeaderPane();
        this.itemsPane.getChildren().addListener(change -> this.headerPane.updateCount());
        this.getChildren().addAll((Object[])new Node[]{this.headerPane, this.itemsPane});
    }

    private void animatedAdd(Node pane) {
        pane.setOpacity(0.0);
        this.itemsPane.getChildren().add(0, (Object)pane);
        FadeTransition transition = new FadeTransition(Duration.millis((double)600.0), pane);
        transition.setToValue(1.0);
        pane.getProperties().put((Object)"animation", (Object)transition);
        transition.setOnFinished(evt -> pane.getProperties().remove((Object)"animation"));
        transition.play();
    }

    void animatedRemove(Node pane) {
        this.headerPane.ensureUncollapsed(false);
        Animation anim = (Animation)pane.getProperties().get((Object)"animation");
        if (anim != null) {
            anim.stop();
        }
        FadeTransition transition = new FadeTransition(Duration.millis((double)200.0), pane);
        transition.setToValue(0.0);
        transition.setOnFinished(evt -> this.itemsPane.getChildren().remove((Object)pane));
        transition.play();
    }

    void add(SimpleNotificationItem item) {
        ArrayList<Node> existingPanes = new ArrayList<Node>();
        for (Node node : this.itemsPane.getChildren()) {
            if (!(node instanceof SimpleItemPane)) continue;
            existingPanes.add(node);
        }
        this.animatedAdd((Node)new SimpleItemPane(item));
        while (existingPanes.size() >= 3) {
            this.animatedRemove((Node)existingPanes.remove(existingPanes.size() - 1));
        }
    }

    void add(ErrorNotificationItem item) {
        BaseStackedItemsPane stackedPane = null;
        ArrayList<ErrorItemPane> existingPanes = new ArrayList<ErrorItemPane>();
        for (Node node : this.itemsPane.getChildren()) {
            if (node instanceof ErrorItemPane) {
                existingPanes.add((ErrorItemPane)node);
                continue;
            }
            if (!(node instanceof StackedErrorItemsPane)) continue;
            stackedPane = (StackedErrorItemsPane)node;
            break;
        }
        if (stackedPane != null) {
            stackedPane.addItem(new ErrorItemPane(item));
            return;
        }
        if (existingPanes.size() < 3) {
            this.animatedAdd((Node)new ErrorItemPane(item));
            return;
        }
        stackedPane = new StackedErrorItemsPane();
        for (ErrorItemPane pane : existingPanes) {
            stackedPane.addItem(new ErrorItemPane((ErrorNotificationItem)pane.item));
        }
        stackedPane.addItem(new ErrorItemPane(item));
        this.animatedAdd((Node)stackedPane);
        for (ErrorItemPane pane : existingPanes) {
            this.animatedRemove((Node)pane);
        }
    }

    void add(List<MessageNotificationItem> items) {
        StackedMessageItemsPane stackedPane = null;
        ArrayList<MessageItemPane> existingPanes = new ArrayList<MessageItemPane>();
        for (Node node : this.itemsPane.getChildren()) {
            if (node instanceof MessageItemPane) {
                existingPanes.add((MessageItemPane)node);
                continue;
            }
            if (!(node instanceof StackedMessageItemsPane)) continue;
            stackedPane = (StackedMessageItemsPane)node;
            break;
        }
        for (MessageNotificationItem item : items) {
            if (stackedPane != null) {
                stackedPane.addItem(new MessageItemPane(item));
                continue;
            }
            if (existingPanes.size() < 3) {
                this.animatedAdd((Node)new MessageItemPane(item));
                continue;
            }
            stackedPane = new StackedMessageItemsPane();
            for (MessageItemPane pane : existingPanes) {
                stackedPane.addItem(new MessageItemPane((MessageNotificationItem)pane.item));
            }
            stackedPane.addItem(new MessageItemPane(item));
            this.animatedAdd((Node)stackedPane);
            for (MessageItemPane pane : existingPanes) {
                this.animatedRemove((Node)pane);
            }
        }
    }

    void add(SystemTaskNotificationItem item) {
        this.animatedAdd((Node)new SystemTaskItemPane(item));
    }

    void add(UserTaskNotificationItem item) {
        BaseStackedItemsPane stackedPane = null;
        ArrayList<UserTaskItemPane> existingPanes = new ArrayList<UserTaskItemPane>();
        for (Node node : this.itemsPane.getChildren()) {
            if (node instanceof UserTaskItemPane) {
                existingPanes.add((UserTaskItemPane)node);
                continue;
            }
            if (!(node instanceof StackedUserTaskItemsPane)) continue;
            stackedPane = (StackedUserTaskItemsPane)node;
            break;
        }
        if (stackedPane != null) {
            stackedPane.addItem(new UserTaskItemPane(item));
            return;
        }
        if (existingPanes.size() < 3) {
            this.animatedAdd((Node)new UserTaskItemPane(item));
            return;
        }
        stackedPane = new StackedUserTaskItemsPane();
        for (UserTaskItemPane pane : existingPanes) {
            stackedPane.addItem(new UserTaskItemPane((UserTaskNotificationItem)pane.item));
        }
        stackedPane.addItem(new UserTaskItemPane(item));
        this.animatedAdd((Node)stackedPane);
        for (UserTaskItemPane pane : existingPanes) {
            this.animatedRemove((Node)pane);
        }
    }

    void remove(BaseNotificationItem item) {
        for (Node node : this.itemsPane.getChildren()) {
            BaseStackedItemsPane pane;
            if (node instanceof BaseItemPane && ((BaseItemPane)node).item == item) {
                this.animatedRemove(node);
                return;
            }
            if (!(node instanceof BaseStackedItemsPane) || !(pane = (BaseStackedItemsPane)node).containsItem(item)) continue;
            if (pane.panes.size() == 1) {
                this.animatedRemove(node);
            } else {
                pane.removeItem(item);
            }
            return;
        }
    }

    class UserTaskItemPane
    extends BaseItemPane<UserTaskNotificationItem> {
        UserTaskItemPane(UserTaskNotificationItem itm) {
            super(NotificationPane.this, (BaseNotificationItem)itm);
            this.getStyleClass().add((Object)"task");
            CustomProgressIndicator progressIndicator = new CustomProgressIndicator();
            progressIndicator.progressProperty().bind((ObservableValue)itm.progress);
            progressIndicator.setTerminationType((TerminationType)((Object)itm.terminationType.get()));
            this.label.setGraphic((Node)progressIndicator);
            Button detailsButton = new Button(Messages.General_Details);
            detailsButton.setOnAction(evt -> itm.detailsCallback.run());
            Button closeButton = new Button();
            closeButton.setOnAction(evt -> {
                if (itm.terminationType.get() != null) {
                    NotificationPane.this.remove(itm);
                } else {
                    itm.interruptCallback.run();
                }
            });
            FxUtil.addListener(itm.terminationType, (src, o, n) -> {
                progressIndicator.setTerminationType((TerminationType)((Object)n));
                closeButton.setText(n == null ? Messages.General_Interrupt : Messages.General_Close);
                NotificationPane.this.headerPane.ensureUncollapsed(n == TerminationType.FAIL);
            });
            this.buildUI(detailsButton, closeButton);
        }

        @Override
        boolean isClosable() {
            return ((UserTaskNotificationItem)this.item).terminationType.get() != null;
        }
    }

    class SystemTaskItemPane
    extends BaseItemPane<SystemTaskNotificationItem> {
        SystemTaskItemPane(SystemTaskNotificationItem itm) {
            super(NotificationPane.this, (BaseNotificationItem)itm);
            this.getStyleClass().add((Object)"task");
            CustomProgressIndicator progressIndicator = new CustomProgressIndicator();
            progressIndicator.setProgress(-1.0);
            this.label.setGraphic((Node)progressIndicator);
            this.buildUI();
        }

        @Override
        boolean isClosable() {
            return false;
        }
    }

    class MessageItemPane
    extends BaseItemPane<MessageNotificationItem> {
        MessageItemPane(MessageNotificationItem itm) {
            super(NotificationPane.this, (BaseNotificationItem)itm);
            switch (itm.messageType) {
                case ERROR: {
                    this.getStyleClass().add((Object)"error");
                    break;
                }
                case WARNING: {
                    this.getStyleClass().add((Object)"warn");
                    break;
                }
                default: {
                    this.getStyleClass().add((Object)"info");
                }
            }
            Button detailsButton = null;
            if (!TextUtil.isBlank((String)itm.details)) {
                detailsButton = new Button(Messages.General_Details);
                detailsButton.setOnAction(evt -> Dialog.message(Messages.General_Updating_details, itm.details));
            }
            Button closeButton = new Button(Messages.General_Close);
            closeButton.setOnAction(evt -> NotificationPane.this.remove(itm));
            this.buildUI(detailsButton, closeButton);
        }

        @Override
        boolean isClosable() {
            return true;
        }
    }

    class ErrorItemPane
    extends BaseItemPane<ErrorNotificationItem> {
        ErrorItemPane(ErrorNotificationItem itm) {
            super(NotificationPane.this, (BaseNotificationItem)itm);
            this.getStyleClass().add((Object)"error");
            Button detailsButton = new Button(Messages.General_Details);
            detailsButton.setOnAction(evt -> Dialog.error(itm.error));
            Button closeButton = new Button(Messages.General_Close);
            closeButton.setOnAction(evt -> NotificationPane.this.remove(itm));
            this.buildUI(detailsButton, closeButton);
        }

        @Override
        boolean isClosable() {
            return true;
        }
    }

    class SimpleItemPane
    extends BaseItemPane<SimpleNotificationItem> {
        SimpleItemPane(SimpleNotificationItem itm) {
            super(NotificationPane.this, (BaseNotificationItem)itm);
            this.getStyleClass().add((Object)"simple");
            this.setOnMouseClicked(evt -> NotificationPane.this.remove(itm));
            if (itm.action == null) {
                this.buildUI();
            } else {
                Button actionButton = new Button(itm.actionCaption);
                actionButton.setOnAction(evt -> {
                    NotificationPane.this.remove(itm);
                    itm.action.run();
                });
                Button closeButton = new Button(Messages.General_Close);
                closeButton.setOnAction(evt -> NotificationPane.this.remove(itm));
                this.buildUI(actionButton, closeButton);
            }
        }

        @Override
        boolean isClosable() {
            return true;
        }
    }

    static abstract class BaseItemPane<I extends BaseNotificationItem>
    extends GridPane {
        final I item;
        final Label label;
        final StackPane marker = new StackPane();
        final GridPane content = new GridPane();
        final GridPane labelPane = new GridPane();
        final /* synthetic */ NotificationPane this$0;

        BaseItemPane(I itm) {
            this.this$0 = this$0;
            this.item = itm;
            this.getStyleClass().add((Object)"item-pane");
            this.marker.getStyleClass().add((Object)"marker");
            GridPane.setConstraints((Node)this.marker, (int)0, (int)0);
            this.content.getStyleClass().add((Object)"content");
            GridPane.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            GridPane.setConstraints((Node)this.content, (int)1, (int)0);
            this.label = new CustomLabel();
            this.label.textProperty().bind((ObservableValue)((BaseNotificationItem)this.item).caption);
            this.labelPane.getStyleClass().add((Object)"label-pane");
            this.labelPane.getChildren().add((Object)this.label);
            this.labelPane.setMaxWidth(Double.MAX_VALUE);
            GridPane.setHgrow((Node)this.labelPane, (Priority)Priority.ALWAYS);
            this.getChildren().addAll((Object[])new Node[]{this.marker, this.content});
            FxUtil.addListener(((BaseNotificationItem)this.item).tooltip, (src, o, n) -> UiUtil.setTooltip((Node)this.label, n));
            this$0.headerPane.ensureUncollapsed(((BaseNotificationItem)this.item).isImportant());
        }

        protected void buildUI() {
            this.content.getChildren().add((Object)this.labelPane);
        }

        protected void buildUI(Button button1, Button button2) {
            GridPane.setConstraints((Node)this.labelPane, (int)0, (int)0);
            GridPane.setColumnSpan((Node)this.labelPane, (Integer)2);
            if (button1 != null) {
                button1.getStyleClass().add((Object)"left-button");
                GridPane.setConstraints((Node)button1, (int)0, (int)1);
                button1.setMaxWidth(Double.MAX_VALUE);
            }
            GridPane.setConstraints((Node)button2, (int)1, (int)1);
            button2.setMaxWidth(Double.MAX_VALUE);
            ColumnConstraints cc = new ColumnConstraints();
            cc.setPercentWidth(50.0);
            cc.setHgrow(Priority.ALWAYS);
            this.content.getColumnConstraints().add((Object)cc);
            cc = new ColumnConstraints();
            cc.setPercentWidth(50.0);
            cc.setHgrow(Priority.ALWAYS);
            this.content.getColumnConstraints().add((Object)cc);
            if (button1 != null) {
                this.content.getChildren().addAll((Object[])new Node[]{this.labelPane, button1, button2});
            } else {
                this.content.getChildren().addAll((Object[])new Node[]{this.labelPane, button2});
            }
        }

        abstract boolean isClosable();
    }

    class StackedUserTaskItemsPane
    extends BaseStackedItemsPane<UserTaskNotificationItem, UserTaskItemPane> {
        StackedUserTaskItemsPane() {
        }
    }

    class StackedMessageItemsPane
    extends BaseStackedItemsPane<MessageNotificationItem, MessageItemPane> {
        StackedMessageItemsPane() {
        }
    }

    class StackedErrorItemsPane
    extends BaseStackedItemsPane<ErrorNotificationItem, ErrorItemPane> {
        StackedErrorItemsPane() {
        }
    }

    abstract class BaseStackedItemsPane<I extends BaseNotificationItem, P extends BaseItemPane<I>>
    extends HBox {
        final List<BaseItemPane<I>> panes = new ArrayList<BaseItemPane<I>>();
        private final StackPane contentPane = new StackPane();
        private final Label counterLabel = new Label();
        private final Button button = new Button();
        private int current;

        BaseStackedItemsPane() {
            this.getStyleClass().add((Object)"stacked-items-pane");
            this.counterLabel.getStyleClass().add((Object)"counter");
            this.button.setGraphic((Node)new IconNode(StandardIconShapes.TILE_NEXT_14x14, (Styleable)this.button, StandardIconIntentions.NOTIFICATION_STACK_BUTTON_ACTION, (Styleable)this.button));
            this.button.getStyleClass().addAll((Object[])new String[]{"stack-button", "xtrip-button"});
            this.getChildren().addAll((Object[])new Node[]{this.contentPane, this.button});
            StackPane.setAlignment((Node)this.counterLabel, (Pos)Pos.TOP_RIGHT);
            HBox.setHgrow((Node)this.contentPane, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.button, (Priority)Priority.NEVER);
            this.button.setOnAction(evt -> {
                ++this.current;
                if (this.current >= this.panes.size()) {
                    this.current = 0;
                }
                this.updateUI();
            });
        }

        private void updateUI() {
            if (this.contentPane.getChildren().isEmpty()) {
                this.contentPane.getChildren().addAll((Object[])new Node[]{(Node)this.panes.get(this.current), this.counterLabel});
            } else {
                this.contentPane.getChildren().set(0, this.panes.get(this.current));
            }
            this.counterLabel.setText(String.valueOf(this.current + 1) + '/' + String.valueOf(this.panes.size()));
            this.button.setDisable(this.panes.size() <= 1);
            NotificationPane.this.headerPane.updateCount();
        }

        void addItem(P pane) {
            this.panes.add((BaseItemPane<I>)((Object)pane));
            this.current = this.panes.size() - 1;
            this.updateUI();
            if (this.getScene() != null) {
                FadeTransition transition = new FadeTransition(Duration.millis((double)200.0), pane);
                transition.setToValue(0.0);
                transition.setCycleCount(5);
                transition.setInterpolator(Interpolator.LINEAR);
                transition.setOnFinished(evt -> pane.setOpacity(1.0));
                transition.play();
            }
        }

        boolean containsItem(BaseNotificationItem item) {
            for (BaseItemPane<I> pane : this.panes) {
                if (!item.equals(pane.item)) continue;
                return true;
            }
            return false;
        }

        void removeItem(BaseNotificationItem item) {
            NotificationPane.this.headerPane.ensureUncollapsed(false);
            Iterator<BaseItemPane<I>> it = this.panes.iterator();
            while (it.hasNext()) {
                if (!item.equals(it.next().item)) continue;
                it.remove();
                break;
            }
            if (this.current >= this.panes.size()) {
                this.current = 0;
            }
            this.updateUI();
        }

        void close() {
            Iterator<BaseItemPane<I>> it = this.panes.iterator();
            while (it.hasNext()) {
                if (!it.next().isClosable()) continue;
                it.remove();
            }
            if (this.panes.isEmpty()) {
                NotificationPane.this.animatedRemove((Node)this);
            } else {
                if (this.current >= this.panes.size()) {
                    this.current = 0;
                }
                this.updateUI();
            }
        }
    }

    private class HeaderPane
    extends GridPane {
        private final Label captionLabel;
        private final Label countLabel;
        private boolean collapsed;
        private Timeline timeline;

        HeaderPane() {
            this.getStyleClass().add((Object)"header-pane");
            this.captionLabel = new Label(Messages.Notifications_Collapse_Caption);
            this.captionLabel.getStyleClass().add((Object)"caption");
            GridPane.setHgrow((Node)this.captionLabel, (Priority)Priority.ALWAYS);
            this.countLabel = new Label();
            this.countLabel.getStyleClass().add((Object)"count");
            Button closeButton = new Button();
            closeButton.getStyleClass().add((Object)"close-button");
            closeButton.setGraphic((Node)new IconNode(StandardIconShapes.CANCEL, (Styleable)closeButton, StandardIconIntentions.CLOSE_BUTTON_ACTION, (Styleable)closeButton));
            UiUtil.setTooltip((Node)closeButton, Messages.Notifications_Close_All);
            closeButton.setOnAction(e -> this.closeAll());
            this.addRow(0, new Node[]{this.captionLabel, this.countLabel, closeButton});
            this.captionLabel.setOnMouseClicked(evt -> {
                if (this.timeline != null) {
                    this.timeline.stop();
                    return;
                }
                this.animate(!this.collapsed);
            });
        }

        private void closeAll() {
            for (Node node : NotificationPane.this.itemsPane.getChildren()) {
                if (node instanceof BaseStackedItemsPane) {
                    ((BaseStackedItemsPane)node).close();
                    continue;
                }
                if (!(node instanceof BaseItemPane) || !((BaseItemPane)node).isClosable()) continue;
                NotificationPane.this.animatedRemove(node);
            }
            this.updateCount();
        }

        void updateCount() {
            int count = 0;
            for (Node node : NotificationPane.this.itemsPane.getChildren()) {
                if (node instanceof BaseStackedItemsPane) {
                    count += ((BaseStackedItemsPane)node).panes.size();
                    continue;
                }
                if (!(node instanceof BaseItemPane)) continue;
                ++count;
            }
            this.countLabel.setText(count == 0 ? null : String.valueOf(count));
        }

        void ensureUncollapsed(boolean force) {
            Stage stage;
            if (this.getScene() != null && !(stage = (Stage)this.getScene().getWindow()).isFocused()) {
                stage.requestFocus();
                stage.toFront();
            }
            if (!this.collapsed) {
                return;
            }
            if (!force) {
                FadeTransition transition = new FadeTransition(Duration.millis((double)200.0), (Node)this);
                transition.setToValue(0.0);
                transition.setCycleCount(2);
                transition.setInterpolator(Interpolator.EASE_BOTH);
                transition.setOnFinished(evt -> this.setOpacity(1.0));
                transition.play();
            } else {
                this.animate(false);
            }
        }

        private void animate(boolean hide) {
            if (hide == this.collapsed) {
                return;
            }
            double gap = NotificationPane.this.getSpacing() + NotificationPane.this.getPadding().getTop() + NotificationPane.this.getPadding().getBottom();
            if (this.collapsed) {
                if (!NotificationPane.this.getChildren().contains((Object)NotificationPane.this.itemsPane)) {
                    NotificationPane.this.getChildren().add((Object)NotificationPane.this.itemsPane);
                }
                NotificationPane.this.setTranslateY(NotificationPane.this.getHeight() - this.getHeight() - gap);
            }
            this.timeline = new Timeline();
            this.timeline.setCycleCount(1);
            KeyValue kv = new KeyValue((WritableValue)NotificationPane.this.translateYProperty(), (Object)(!hide ? 0.0 : NotificationPane.this.getHeight() - this.getHeight() - gap), Interpolator.EASE_OUT);
            this.timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{kv}));
            this.timeline.setOnFinished(e -> {
                this.collapsed = hide;
                NotificationPane.this.setTranslateY(0.0);
                if (!this.collapsed) {
                    this.captionLabel.setText(Messages.Notifications_Collapse_Caption);
                } else {
                    this.captionLabel.setText(Messages.Notifications_Expand_Caption);
                    NotificationPane.this.getChildren().remove((Object)NotificationPane.this.itemsPane);
                }
                this.timeline = null;
            });
            this.timeline.play();
        }
    }
}

