/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.tasks;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.ErrorNotificationItem;
import com.gridnine.xtrip.client.fx.core.tasks.MessageNotificationItem;
import com.gridnine.xtrip.client.fx.core.tasks.NotificationPane;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.tasks.SimpleNotificationItem;
import com.gridnine.xtrip.client.fx.core.tasks.SystemTaskNotificationItem;
import com.gridnine.xtrip.client.fx.core.util.ActivityTracker;
import com.gridnine.xtrip.client.fx.core.util.DumpDataUtil;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.Executable;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.GeneralFxService;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.util.Duration;
import javax.management.MBeanServer;

public class Notifications
implements Disposable {
    final ExecutorService executor;
    private final ExecutorService asyncTasksExecutor;
    private final ScheduledExecutorService scheduler;
    final NotificationPane notificationPane;
    private final Map<ObservableMutex, Queue<Executable>> batches = new HashMap<ObservableMutex, Queue<Executable>>();
    boolean disposed;

    public static Notifications get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (Notifications)Environment.getPublished(Notifications.class);
    }

    public Notifications(NotificationPane pane) {
        this.notificationPane = pane;
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "fx-bg-thread:" + this.counter.getAndIncrement());
            }
        });
        this.asyncTasksExecutor = Executors.newFixedThreadPool(2, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "fx-async-task:" + this.counter.getAndIncrement());
            }
        });
        this.scheduler = Executors.newScheduledThreadPool(2, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "fx-timer:" + this.counter.getAndIncrement());
            }
        });
        ErrorHandler.register(new ErrorHandler(){
            private Function<Throwable, Throwable> oomHandler;
            {
                try {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Class<?> beanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                    Object beanProxy = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", beanClass);
                    Method doDumpMethod = beanClass.getMethod("dumpHeap", String.class, Boolean.TYPE);
                    this.oomHandler = error -> {
                        try {
                            File file = DumpDataUtil.newFile(DumpDataUtil.DataKind.HEAP_DUMP);
                            if (file.isFile()) {
                                file.delete();
                            }
                            doDumpMethod.invoke(beanProxy, file.getAbsolutePath(), Boolean.TRUE);
                            this.oomHandler = null;
                            return Xeption.forDeveloper((String)"out of memory fault, memory dump generated to file {0}", (Throwable)error, (Object[])new Object[]{file});
                        }
                        catch (Exception e) {
                            ErrorHandler.LOG.error("failed creating memory dump", (Throwable)e);
                            return error;
                        }
                    };
                }
                catch (Exception e) {
                    ErrorHandler.LOG.error("failed initializing OOM handler", (Throwable)e);
                }
            }

            @Override
            public void handleError(Throwable error) {
                boolean oomError = this.isOOMError(error);
                Throwable fault = this.oomHandler != null && oomError ? this.oomHandler.apply(error) : error;
                if (oomError || ErrorHandler.isUncaughtError(error)) {
                    ActivityTracker.enrichException(fault);
                }
                ErrorHandler.LOG.error(fault.getMessage(), fault);
                FxUtil.runInFxThread(() -> Notifications.this.notificationPane.add(new ErrorNotificationItem(fault)));
                Thread thread = Thread.currentThread();
                if (!Platform.isFxApplicationThread()) {
                    Notifications.this.registerError(thread, fault);
                } else if (!Notifications.this.disposed) {
                    Notifications.this.executor.submit(() -> Notifications.this.registerError(thread, fault));
                }
            }

            private boolean isOOMError(Throwable error) {
                if (error == null) {
                    return false;
                }
                if (error instanceof OutOfMemoryError) {
                    return true;
                }
                return this.isOOMError(error.getCause());
            }
        });
    }

    protected void registerError(Thread thread, Throwable error) {
        if (IncidentsLog.isIgnore((Throwable)error)) {
            return;
        }
        try {
            ((GeneralFxService)RpcServiceManager.get().getService(GeneralFxService.class)).logError(ServiceInvocationContext.get(), thread.getName(), ErrorHandler.getMessage(error), ErrorHandler.getDetails(error));
        }
        catch (Exception e) {
            ErrorHandler.LOG.error("failed registering error", (Throwable)e);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.scheduler.shutdownNow();
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.asyncTasksExecutor.shutdownNow();
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public void submitTask(Executable task, String description) {
        if (this.disposed) {
            return;
        }
        SystemTaskNotificationItem item = new SystemTaskNotificationItem(description);
        FxUtil.runInFxThread(() -> this.notificationPane.add(item));
        this.executor.execute(() -> {
            try {
                task.execute();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
            finally {
                Platform.runLater(() -> this.notificationPane.remove(item));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitTask(Executable task, ObservableMutex mutex) {
        if (mutex == null) {
            this.submitTask(task, Messages.General_Background_process);
            return;
        }
        if (this.disposed) {
            return;
        }
        Map<ObservableMutex, Queue<Executable>> map = this.batches;
        synchronized (map) {
            this.batches.computeIfAbsent(mutex, key -> new LinkedList()).add(task);
        }
        this.executor.execute(() -> {
            try {
                mutex.acquire();
                Executable firstTask = null;
                Map<ObservableMutex, Queue<Executable>> map = this.batches;
                synchronized (map) {
                    firstTask = this.batches.get(mutex).remove();
                    if (this.batches.get(mutex).size() == 0) {
                        this.batches.remove(mutex);
                    }
                }
                firstTask.execute();
            }
            catch (InterruptedException firstTask) {
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
            finally {
                mutex.release();
            }
        });
    }

    public void enqueueAsyncTask(ServerTaskHandler handler) {
        if (this.disposed) {
            return;
        }
        handler.init(this.notificationPane);
        this.executor.execute(() -> {
            try {
                handler.execute();
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
        });
    }

    public void enqueueAsyncTask(ClientTask task) {
        if (this.disposed) {
            return;
        }
        task.init(this.notificationPane);
        task.submit(this.asyncTasksExecutor);
    }

    public void showFlashNotification(String mrssage) {
        this.showFlashNotification(mrssage, null);
    }

    public void showFlashNotification(String message, String tooltip) {
        this.addNotification(Duration.seconds((double)7.0), message, tooltip, null, null);
    }

    public void showStaticNotification(String message) {
        this.showStaticNotification(message, null);
    }

    public void showStaticNotification(String message, String tooltip) {
        this.showStaticNotification(message, tooltip, null, null);
    }

    public void showStaticNotification(String message, String actionCaption, Runnable action) {
        this.showStaticNotification(message, null, actionCaption, action);
    }

    public void showStaticNotification(String message, String tooltip, String actionCaption, Runnable action) {
        this.addNotification(Duration.INDEFINITE, message, tooltip, actionCaption, action);
    }

    public void showMessages(Message ... messages) {
        FxUtil.runInFxThread(() -> this.notificationPane.add(Arrays.stream(messages).map(MessageNotificationItem::new).collect(Collectors.toList())));
    }

    public void showMessages(Collection<Message> messages) {
        FxUtil.runInFxThread(() -> this.notificationPane.add(messages.stream().map(MessageNotificationItem::new).collect(Collectors.toList())));
    }

    private void addNotification(Duration duration, String message, String tooltip, String actionCaption, Runnable action) {
        FxUtil.runInFxThread(() -> {
            SimpleNotificationItem item = new SimpleNotificationItem(message);
            item.tooltip.set(tooltip);
            item.actionCaption = actionCaption;
            item.action = action;
            this.notificationPane.add(item);
            if (!Duration.INDEFINITE.equals((Object)duration) && !Duration.UNKNOWN.equals((Object)duration) && duration.greaterThan(Duration.ZERO)) {
                this.scheduler.schedule(() -> Platform.runLater(() -> this.notificationPane.remove(item)), Math.round(duration.toSeconds()), TimeUnit.SECONDS);
            }
        });
    }

    private static class Holder {
        public static final Notifications INSTANCE = (Notifications)Environment.getPublished(Notifications.class);

        private Holder() {
        }
    }
}

