/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.tasks;

import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.progressindicator.TerminationType;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.tasks.NotificationPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.UserTaskNotificationItem;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.common.fx.assets.AsyncTaskAssignment;
import com.gridnine.xtrip.common.fx.rpc.AsyncTaskData;
import com.gridnine.xtrip.common.fx.rpc.AsyncTasksService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;

public abstract class ServerTaskHandler {
    final ObjectProperty<AsyncTaskData<?>> taskData = new SimpleObjectProperty();
    private UserTaskNotificationItem item;
    private final List<Message> messageLog = new ArrayList<Message>();

    static void showTaskInfo(AsyncTaskAssignment.TaskState state, Throwable error, List<Message> messageLog) {
        StringBuilder buf = new StringBuilder();
        buf.append("State: ").append(state).append('\n');
        if (error != null) {
            buf.append('\n').append("Error: ").append(error).append('\n');
            buf.append(ErrorHandler.getDetails(error)).append('\n');
        }
        StringBuilder bufDetail = new StringBuilder(buf);
        for (Message message : messageLog) {
            if (message.getXeptionMessage() != null) {
                buf.append('\n').append(message.getType()).append(": ").append(message.getXeptionMessage());
            } else {
                buf.append('\n').append(message.getType()).append(": ").append(message.getMessage());
                if (message.getDetails() != null) {
                    buf.append('\n').append(message.getDetails());
                }
            }
            bufDetail.append('\n').append(message.getType()).append(": ").append(message.getMessage());
            if (message.getDetails() == null) continue;
            bufDetail.append('\n').append(message.getDetails());
        }
        TextAreaWidget widget = new TextAreaWidget(true);
        widget.setValue(buf.toString());
        widget.getViewState().setNotEditable(true);
        widget.setWrapText(true);
        new Dialog().setTitle(Messages.General_Task_info).setBody((Node)widget).addButton(DialogButtonStyle.AUXILARY, Messages.General_Copy1, () -> Clipboard.getSystemClipboard().setContent(Collections.singletonMap(DataFormat.PLAIN_TEXT, bufDetail.toString()))).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Close).showGlobal();
    }

    protected abstract String getTitle();

    protected abstract String getTaskClassName();

    protected abstract Serializable getTaskParameters();

    protected abstract void onCompleted(Object var1, List<Message> var2);

    protected void onInterrupted(List<Message> log) {
    }

    void init(NotificationPane notificationPane) {
        this.item = new UserTaskNotificationItem(() -> {
            AsyncTaskData data = (AsyncTaskData)this.taskData.get();
            if (data != null) {
                ServerTaskHandler.showTaskInfo(data.getState(), data.getError(), this.messageLog);
            }
        }, () -> this.doInterrupt());
        this.item.caption.set((Object)this.getTitle());
        this.taskData.addListener((src, oldValue, newValue) -> {
            this.item.caption.set((Object)this.getTitle());
            if (newValue == null) {
                return;
            }
            this.messageLog.clear();
            this.messageLog.addAll(newValue.getLog());
            if (newValue.getState() != null && newValue.getState().isFinished()) {
                if (this.hasErrors((AsyncTaskData<?>)newValue)) {
                    this.item.terminationType.set((Object)TerminationType.FAIL);
                } else if (newValue.getState() == AsyncTaskAssignment.TaskState.INTERRUPTED) {
                    this.item.terminationType.set((Object)TerminationType.ABORT);
                } else {
                    this.item.terminationType.set((Object)TerminationType.SUCCESS);
                }
                this.item.progress.set(1.0);
            } else {
                byte progress = newValue.getProgress();
                this.item.progress.set(progress < 0 || progress > 100 ? -1.0 : (double)progress / 100.0);
            }
            this.item.tooltip.set(newValue.getMessage());
            EventBus.get().publishAsync(new AssetModificationEvent(new AssetModification((BaseAsset)new AsyncTaskAssignment(newValue.getId()), AssetModification.ModificationType.CHANGE)));
        });
        FxUtil.runInFxThread(() -> notificationPane.add(this.item));
    }

    private boolean hasErrors(AsyncTaskData<?> data) {
        return data != null && (data.getError() != null || MessagesHelper.hasErrorMessage(this.messageLog));
    }

    void doInterrupt() {
        AsyncTaskData data = (AsyncTaskData)this.taskData.get();
        if (data == null) {
            return;
        }
        String id = data.getId();
        Notifications.get().submitTask(() -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            AsyncTasksService tasksService = (AsyncTasksService)RpcServiceManager.get().getService(AsyncTasksService.class);
            AsyncTaskData newData = tasksService.interrupt(sic, id);
            FxUtil.submitToFxThread(() -> this.taskData.set((Object)newData));
        }, Messages.General_Cancel_task + " \"" + this.getTitle() + "\".");
    }

    void execute() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        AsyncTasksService tasksService = (AsyncTasksService)RpcServiceManager.get().getService(AsyncTasksService.class);
        ValueHolder<AsyncTaskData> data = new ValueHolder<AsyncTaskData>();
        data.set(tasksService.enqueue(sic, this.getTaskClassName(), this.getTaskParameters()));
        FxUtil.waitForFxThread(() -> this.taskData.set(data.get()));
        while (data.get() != null && ((AsyncTaskData)data.get()).getState() != null && !((AsyncTaskData)data.get()).getState().isFinished() && !Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ie) {
                break;
            }
            try {
                data.set(tasksService.getData(sic, ((AsyncTaskData)data.get()).getId()));
                FxUtil.waitForFxThread(() -> this.taskData.set(data.get()));
            }
            catch (Exception e) {
                ErrorHandler.handle(e);
            }
        }
        if (data.get() != null) {
            if (((AsyncTaskData)data.get()).getState() == AsyncTaskAssignment.TaskState.COMPLETED) {
                this.onCompleted(((AsyncTaskData)data.get()).getResult(), this.messageLog);
            } else if (((AsyncTaskData)data.get()).getState() == AsyncTaskAssignment.TaskState.INTERRUPTED) {
                this.onInterrupted(this.messageLog);
            }
            if (this.cleanupOnCompletion()) {
                tasksService.cleanup(sic, ((AsyncTaskData)data.get()).getId());
            }
        }
        FxUtil.submitToFxThread(() -> this.item.caption.set((Object)this.getTitle()));
    }

    protected boolean cleanupOnCompletion() {
        return true;
    }
}

