/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.res.FxRes;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class LogoPane
extends StackPane {
    private StackPane buttonPane;
    private DoubleProperty animationTransition;
    private Region button;

    public LogoPane() {
        this.getStyleClass().add((Object)"xtrip-logo-pane");
        this.createGUI();
        this.createListeners();
    }

    private void createGUI() {
        Pane logoPane = this.createLogoPane();
        this.getChildren().addAll((Object[])new Node[]{logoPane});
    }

    private Pane createLogoPane() {
        Pane logoPaneLogoPane = this.createLogoPaneLogoPane();
        Pane logoPaneButtonPane = this.createLogoPaneButtonPane();
        AnchorPane logoPaneContainerPane = new AnchorPane();
        logoPaneContainerPane.getStyleClass().add((Object)"xtrip-logo-pane-container-pane");
        AnchorPane.setLeftAnchor((Node)logoPaneLogoPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)logoPaneLogoPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)logoPaneLogoPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)logoPaneLogoPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)logoPaneButtonPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)logoPaneButtonPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)logoPaneButtonPane, (Double)0.0);
        logoPaneContainerPane.getChildren().addAll((Object[])new Node[]{logoPaneLogoPane, logoPaneButtonPane});
        return logoPaneContainerPane;
    }

    private Pane createLogoPaneLogoPane() {
        Label logoPaneLogoLabel = new Label();
        logoPaneLogoLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        logoPaneLogoLabel.getStyleClass().add((Object)"xtrip-logo-pane-logo-label");
        logoPaneLogoLabel.setGraphic((Node)new ImageView(FxRes.getTheme().getLogo().toExternalForm()));
        StackPane logoPaneLogoContainerPane = new StackPane();
        logoPaneLogoContainerPane.getStyleClass().add((Object)"xtrip-logo-pane-logo-container-pane");
        logoPaneLogoContainerPane.getChildren().addAll((Object[])new Node[]{logoPaneLogoLabel});
        return logoPaneLogoContainerPane;
    }

    private Pane createLogoPaneButtonPane() {
        this.button = new Region();
        this.buttonPane = new StackPane(new Node[]{this.button});
        this.buttonPane.getStyleClass().add((Object)"xtrip-logo-pane-button-container-pane");
        UiUtil.setTooltip((Node)this.buttonPane, Messages.General_Hide_show_navigation_panel);
        return this.buttonPane;
    }

    private void createListeners() {
        this.animationTransitionProperty().addListener((observable, oldValue, newValue) -> this.button.setRotate(180.0 * newValue.doubleValue()));
    }

    public final DoubleProperty animationTransitionProperty() {
        if (this.animationTransition == null) {
            this.animationTransition = new SimpleDoubleProperty((Object)this, "animationTransition");
        }
        return this.animationTransition;
    }

    public final void setAnimationTransition(double value) {
        this.animationTransitionProperty().set(value);
    }

    public final double getAnimationTransition() {
        return this.animationTransition != null ? this.animationTransition.get() : 0.0;
    }

    public Node getButton() {
        return this.buttonPane;
    }
}

