/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.core.ui.navigation;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.WorkspaceService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.LoggerFactory;

public final class WorkspaceHelper {
    public static FxWorkspace loadWorkspace() throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        FxWorkspace result = ((WorkspaceService)RpcServiceManager.get().getService(WorkspaceService.class)).getWorkspace(sic, sic.getUser(), false);
        WorkspaceHelper.applyACL(result);
        return result;
    }

    public static void applyACL(FxWorkspace workspace) throws Exception {
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        WorkspaceHelper.buildAclQueries(map, workspace.getItems());
        Set<String> grantedUids = FxAclUtil.applyACL(map);
        WorkspaceHelper.enforceAcl(workspace.getItems(), map.keySet(), grantedUids);
    }

    private static void buildAclQueries(Map<String, AclQuery> map, List<FxWorkspaceItem> items) {
        for (FxWorkspaceItem item : items) {
            NavTool<?> tool = NavTool.forId(item.getToolId());
            if (tool == null) continue;
            try {
                AclQuery query = tool.itemACLQuery(tool.getSerializer().deserialize(item.getParameters()));
                if (query != null) {
                    map.put(item.getUid(), query);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(WorkspaceHelper.class).error(String.format("failed getting ACL query for %s (%s)", item.getName(), item.getUid()), (Throwable)e);
            }
            WorkspaceHelper.buildAclQueries(map, item.getSubItems());
        }
    }

    private static void enforceAcl(List<FxWorkspaceItem> items, Set<String> requestedUids, Set<String> grantedUids) {
        Iterator<FxWorkspaceItem> it = items.iterator();
        while (it.hasNext()) {
            FxWorkspaceItem item = it.next();
            if (requestedUids.contains(item.getUid()) && !grantedUids.contains(item.getUid())) {
                it.remove();
                continue;
            }
            WorkspaceHelper.enforceAcl(item.getSubItems(), requestedUids, grantedUids);
        }
    }

    private WorkspaceHelper() {
    }
}

